/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crops;

import com.bafomdad.uniquecrops.blocks.BlockCropsBase;
import com.bafomdad.uniquecrops.core.enums.EnumCrops;
import com.bafomdad.uniquecrops.data.UCDataHandler;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Imperia
extends BlockCropsBase {
    public Imperia() {
        super(EnumCrops.IMPERIA);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void imperiaDenySpawn(LivingSpawnEvent.CheckSpawn event) {
        ChunkPos cPos = new ChunkPos(event.getEntityLiving().func_180425_c());
        if (!event.getWorld().field_72995_K && !event.isSpawner() && event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false) && UCDataHandler.getInstance().getChunkInfo(event.getWorld().field_73011_w.getDimension()).contains(cPos)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public Item func_149866_i() {
        return UCItems.seedsImperia;
    }

    public Item func_149865_P() {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public int func_149750_m(IBlockState state) {
        if (this.func_185527_x(state) >= this.func_185526_g()) {
            return 15;
        }
        return 0;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            if (this.func_185527_x(state) >= this.func_185526_g()) {
                this.setChunksAsNeeded(world, pos, false);
            }
            String[] mobList = new String[]{"minecraft:witch", "minecraft:skeleton", "minecraft:zombie", "minecraft:spider"};
            Entity randomMob = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(mobList[rand.nextInt(mobList.length)]), (World)world);
            randomMob.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
            NBTTagCompound entityTag = randomMob.getEntityData();
            entityTag.func_74782_a("ImperiaPosTag", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            entityTag.func_74768_a("ImperiaStage", this.func_185527_x(state));
            if (!world.field_72995_K) {
                world.func_72838_d(randomMob);
            }
            return;
        }
        super.func_180650_b(world, pos, state, rand);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.setChunksAsNeeded(world, pos, true);
        super.func_180663_b(world, pos, state);
    }

    public void advanceStage(World world, BlockPos pos, IBlockState state, int stage) {
        if (this.func_185527_x(state) >= this.func_185526_g() || stage != this.func_185527_x(state)) {
            return;
        }
        if (this.func_185527_x(state) + 1 >= this.func_185526_g()) {
            this.setChunksAsNeeded(world, pos, false);
        }
        UCPacketHandler.sendToNearbyPlayers(world, pos, new PacketUCEffect(EnumParticleTypes.CLOUD, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 6));
        world.func_180501_a(pos, this.func_185528_e(this.func_185527_x(state) + 1), 3);
    }

    public void setChunksAsNeeded(World world, BlockPos pos, boolean remove) {
        ChunkPos cPos = new ChunkPos(pos);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ChunkPos loopPos = new ChunkPos(cPos.field_77276_a + i, cPos.field_77275_b + j);
                if (remove) {
                    UCDataHandler.getInstance().removeChunk(world.field_73011_w.getDimension(), loopPos, true);
                    continue;
                }
                UCDataHandler.getInstance().addChunk(world.field_73011_w.getDimension(), loopPos, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        this.createParticles(state, world, pos, rand, EnumParticleTypes.END_ROD, 0);
    }
}

