/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.data;

import com.bafomdad.uniquecrops.data.UCDataHandler;
import com.bafomdad.uniquecrops.data.UCOreHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class UCWorldData
extends WorldSavedData {
    public static final String ID = "UCWorldData";

    public UCWorldData(String name) {
        super(name);
    }

    public UCWorldData() {
        this(ID);
    }

    public void func_76184_a(NBTTagCompound tag) {
        int[] dims;
        for (int dimId : dims = tag.func_74759_k("savedDims")) {
            NBTTagList savedList = tag.func_150295_c("savedList" + dimId, 10);
            UCDataHandler.getInstance().clearQueue(dimId);
            for (int i = 0; i < savedList.func_74745_c(); ++i) {
                NBTTagCompound saveTag = savedList.func_150305_b(i);
                ChunkPos cPos = new ChunkPos(saveTag.func_74762_e("chunkX"), saveTag.func_74762_e("chunkZ"));
                UCDataHandler.getInstance().addChunk(dimId, cPos, false);
            }
        }
        NBTTagList tagList = tag.func_150295_c("savedOres", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound chunkTag = tagList.func_150305_b(i);
            BlockPos pos = BlockPos.func_177969_a((long)chunkTag.func_74763_f("blockPos"));
            BlockPos cPos = BlockPos.func_177969_a((long)chunkTag.func_74763_f("chunkPos"));
            UCOreHandler.getInstance().getSaveInfo().put(new ChunkPos(cPos.func_177958_n(), cPos.func_177952_p()), pos);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        Integer[] allDims = UCDataHandler.getInstance().getUnsavedDims().toArray(new Integer[0]);
        int[] savedDims = new int[allDims.length];
        for (int i = 0; i < allDims.length; ++i) {
            savedDims[i] = allDims[i];
        }
        tag.func_74783_a("savedDims", savedDims);
        for (int d : savedDims) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(d);
            if (world == null) continue;
            NBTTagList savedList = new NBTTagList();
            for (ChunkPos pos : UCDataHandler.getInstance().getChunkInfo(d)) {
                NBTTagCompound chunkTag = new NBTTagCompound();
                chunkTag.func_74768_a("chunkX", pos.field_77276_a);
                chunkTag.func_74768_a("chunkZ", pos.field_77275_b);
                savedList.func_74742_a((NBTBase)chunkTag);
            }
            tag.func_74782_a("savedList" + d, (NBTBase)savedList);
        }
        NBTTagList tagList = new NBTTagList();
        for (ChunkPos cPos : UCOreHandler.getInstance().getUnsavedChunks()) {
            NBTTagCompound chunkTag = new NBTTagCompound();
            chunkTag.func_74772_a("chunkPos", new BlockPos(cPos.field_77276_a, 0, cPos.field_77275_b).func_177986_g());
            chunkTag.func_74772_a("blockPos", UCOreHandler.getInstance().getSaveInfo().get(cPos).func_177986_g());
            tagList.func_74742_a((NBTBase)chunkTag);
        }
        tag.func_74782_a("savedOres", (NBTBase)tagList);
        return tag;
    }

    public static UCWorldData getInstance(int dimId) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimId);
        if (world != null) {
            WorldSavedData handler = world.func_175693_T().func_75742_a(UCWorldData.class, ID);
            if (handler == null) {
                handler = new UCWorldData();
                world.func_175693_T().func_75745_a(ID, handler);
            }
            return (UCWorldData)handler;
        }
        return null;
    }
}

