/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.dimension;

import com.bafomdad.uniquecrops.init.UCBlocks;
import com.google.common.collect.ImmutableList;
import java.awt.geom.Ellipse2D;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;

public class CropWorldChunkGenerator
implements IChunkGenerator {
    private Random rand;
    private final World world;
    private NoiseGeneratorPerlin noiseGen;
    private NoiseGeneratorSimplex simplexGen;

    public CropWorldChunkGenerator(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.noiseGen = new NoiseGeneratorPerlin(this.rand, 4);
        this.simplexGen = new NoiseGeneratorSimplex(this.rand);
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer primer = new ChunkPrimer();
        Chunk chunk = new Chunk(this.world, primer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk2(int chunkX, int chunkZ, ChunkPrimer primer) {
        int offset = 20;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int xRange = this.rand.nextInt(4) + 8;
        int zRange = this.rand.nextInt(4) + 8;
        double[] noise = new double[256];
        Ellipse2D.Double ellipse = new Ellipse2D.Double(4.0, 4.0, xRange, zRange);
        int l = 0;
        int lowest = 256;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (ellipse.contains(i, j)) {
                    double k = 4.0 * this.noiseGen.func_151601_a((double)(x + i), (double)(z + j));
                    noise[l] = k + 1.0;
                    if ((int)k < lowest && k > 0.0) {
                        lowest = (int)k;
                    }
                } else {
                    noise[l] = 0.0;
                }
                ++l;
            }
        }
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int offset = 32;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                double k = 32.0 * this.getAltitude(x + i, z + j, 0.125);
                if (k + 28.0 > (double)offset && k + 28.0 < 255.0) {
                    primer.func_177855_a(i, offset + (int)k, j, UCBlocks.oldGrass.func_176223_P());
                    if (-k + (double)offset + 1.0 >= 0.0) {
                        primer.func_177855_a(i, (int)(-k + (double)offset) + 1, j, Blocks.field_150346_d.func_176223_P());
                    }
                }
                for (int y = 255; y > 0; --y) {
                    if (!((double)y < k + 31.0) || !((double)y > -k + (double)offset)) continue;
                    primer.func_177855_a(i, y, j, Blocks.field_150346_d.func_176223_P());
                }
            }
        }
    }

    private double getAltitude(double i, double j, double delta) {
        return Math.sin(i * delta) * Math.cos(j * delta);
    }

    private double getNoiseGen(double i, double j, double delta) {
        return this.noiseGen.func_151601_a(i * delta, j * delta);
    }

    private boolean shouldFillChunk(int x, int z) {
        int xOffset = x;
        int zOffset = z;
        int spacing = 4;
        int clusterSize = 1;
        int width = spacing + clusterSize;
        if (xOffset < 0) {
            xOffset = -xOffset + clusterSize;
        }
        if (zOffset < 0) {
            zOffset = -zOffset + clusterSize;
        }
        return (xOffset %= width) < clusterSize && (zOffset %= width) < clusterSize;
    }

    public void func_185931_b(int x, int z) {
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        return ImmutableList.of();
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return false;
    }
}

