/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.events;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.api.IBookUpgradeable;
import com.bafomdad.uniquecrops.api.IItemBooster;
import com.bafomdad.uniquecrops.blocks.tiles.TileDigger;
import com.bafomdad.uniquecrops.blocks.tiles.TileGoblet;
import com.bafomdad.uniquecrops.blocks.tiles.TileItero;
import com.bafomdad.uniquecrops.blocks.tiles.TileMusicaPlant;
import com.bafomdad.uniquecrops.capabilities.CPCapability;
import com.bafomdad.uniquecrops.capabilities.CPProvider;
import com.bafomdad.uniquecrops.core.MultiblockPattern;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.SeedBehavior;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.core.UCUtils;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.crops.Enderlily;
import com.bafomdad.uniquecrops.crops.Imperia;
import com.bafomdad.uniquecrops.crops.supercrops.Itero;
import com.bafomdad.uniquecrops.data.UCOreHandler;
import com.bafomdad.uniquecrops.dimension.CropWorldTeleporter;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCDimension;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.items.ItemAnkh;
import com.bafomdad.uniquecrops.items.ItemBrassKnuckles;
import com.bafomdad.uniquecrops.items.ItemGeneric;
import com.bafomdad.uniquecrops.items.ItemImpactShield;
import com.bafomdad.uniquecrops.items.ItemThunderpants;
import com.bafomdad.uniquecrops.network.PacketSyncCap;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;

public class UCEventHandlerServer {
    private int cost;
    private int range = 5;

    @SubscribeEvent
    public void updateAnvilCost(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        if (left.func_77973_b() == Items.field_151134_bR && right.func_77973_b() != Items.field_151134_bR || left.func_77973_b() != Items.field_151134_bR && right.func_77973_b() == Items.field_151134_bR) {
            int newCost;
            ItemStack toCheck;
            ItemStack output = this.updateRepairOutput(left, right);
            ItemStack itemStack = toCheck = left.func_77973_b() != Items.field_151134_bR ? left.func_77946_l() : right.func_77946_l();
            if (!output.func_190926_b() && this.checkNBT(toCheck) && (newCost = this.cost) > 5) {
                event.setOutput(output.func_77946_l());
                event.setCost(newCost -= 5);
            }
            return;
        }
        if (left.func_77973_b() == UCItems.generic && left.func_77952_i() == 18 && right.func_77973_b() instanceof IBookUpgradeable || left.func_77973_b() instanceof IBookUpgradeable && right.func_77973_b() == UCItems.generic && right.func_77952_i() == 18) {
            ItemStack output;
            ItemStack itemStack = output = left.func_77973_b() instanceof IBookUpgradeable ? left.func_77946_l() : right.func_77946_l();
            if (!output.func_190926_b()) {
                ItemStack newcopy = output.func_77946_l();
                IBookUpgradeable upgrade = (IBookUpgradeable)newcopy.func_77973_b();
                if (upgrade.getLevel(newcopy) >= 10) {
                    return;
                }
                if (upgrade.getLevel(newcopy) <= 0) {
                    upgrade.setLevel(newcopy, 1);
                } else {
                    int upgradelevel = upgrade.getLevel(newcopy);
                    upgrade.setLevel(newcopy, upgradelevel + 1);
                }
                event.setOutput(newcopy);
                event.setCost(5);
            }
            return;
        }
    }

    @SubscribeEvent
    public void setUpgradeChance(AnvilRepairEvent event) {
        int upgradelevel;
        ItemStack output = event.getItemResult();
        EntityPlayer player = event.getEntityPlayer();
        if (output.func_190926_b() || player == null) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (output.func_77973_b() instanceof IBookUpgradeable && (upgradelevel = ((IBookUpgradeable)output.func_77973_b()).getLevel(output)) == 10) {
            Random rand = new Random();
            if (rand.nextBoolean()) {
                return;
            }
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You attempt to refine this item, but it fails.."));
            ((IBookUpgradeable)output.func_77973_b()).setLevel(output, upgradelevel--);
        }
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase elb = event.getEntityLiving();
        if (elb.field_70170_p.field_72995_K) {
            return;
        }
        if (elb instanceof EntityPlayer && elb.field_70170_p.func_180495_p(elb.func_180425_c()).func_177230_c() == UCBlocks.teleLily) {
            for (int i = 1; i < 12; ++i) {
                BlockPos loopPos = elb.func_180425_c().func_177967_a(EnumFacing.UP, i);
                if (elb.field_70170_p.func_180495_p(loopPos).func_177230_c() != UCBlocks.teleLily) continue;
                elb.field_70181_x = 0.0;
                elb.func_70634_a((double)loopPos.func_177958_n() + 0.5, (double)loopPos.func_177984_a().func_177956_o(), (double)loopPos.func_177952_p() + 0.5);
                return;
            }
        }
    }

    @SubscribeEvent
    public void noteBlockPlayEvent(NoteBlockEvent.Play event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        BlockPos epos = event.getPos();
        int range = 10;
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)epos.func_177982_a(-range, -2, -range), (BlockPos)epos.func_177982_a(range, 2, range))) {
            TileEntity te = event.getWorld().func_175625_s(pos);
            if (!(te instanceof TileMusicaPlant)) continue;
            TileMusicaPlant plant = (TileMusicaPlant)te;
            if (plant.getBeats().size() > 0) {
                for (int i = 0; i < plant.getBeats().size(); ++i) {
                    TileMusicaPlant.Beat beat = plant.getBeats().get(i);
                    if (!beat.beatMatches(new TileMusicaPlant.Beat(event.getNote(), event.getInstrument(), event.getOctave(), event.getWorld().func_82737_E()))) continue;
                    plant.setNewBeatTime(i, event.getWorld().func_82737_E());
                    return;
                }
            }
            if (!plant.canAddNote()) continue;
            plant.setNote(event.getNote(), event.getInstrument(), event.getOctave(), event.getWorld().func_82737_E());
        }
    }

    @SubscribeEvent
    public void checkHarvestedCrops(BlockEvent.HarvestDropsEvent event) {
        Block crop = event.getState().func_177230_c();
        if (event.getHarvester() != null && event.getHarvester().field_71075_bZ.field_75098_d) {
            return;
        }
        if (crop == UCBlocks.cropInvisibilia && event.getHarvester() == null) {
            event.getDrops().clear();
            event.setResult(Event.Result.DEFAULT);
        }
        if (crop == UCBlocks.cropFeroxia && ((BlockCrops)crop).func_185525_y(event.getState())) {
            if (!(event.getHarvester() instanceof FakePlayer)) {
                UCUtils.generateSteps(event.getHarvester());
            } else {
                event.getDrops().clear();
            }
            event.setResult(Event.Result.DEFAULT);
        }
        if (crop == UCBlocks.cropDyeius && !event.getDrops().isEmpty()) {
            for (ItemStack stack : event.getDrops()) {
                if (stack.func_77973_b() != Items.field_151100_aR) continue;
                long time = event.getWorld().func_72820_D() % 24000L;
                int meta = (int)(time / 1500L);
                if (EnumDyeColor.func_176764_b((int)meta) == EnumDyeColor.BLUE) {
                    event.getDrops().remove(stack);
                    event.getDrops().add(new ItemStack((Item)UCItems.generic, 1, EnumItems.BLUEDYE.ordinal()));
                    return;
                }
                LocalDateTime current = LocalDateTime.now();
                if (current.getDayOfWeek() == DayOfWeek.FRIDAY) {
                    stack.func_77964_b(EnumDyeColor.func_176764_b((int)meta).func_176765_a());
                    continue;
                }
                stack.func_77964_b(EnumDyeColor.func_176764_b((int)meta).func_176767_b());
            }
        }
    }

    @SubscribeEvent
    public void checkEntityDeath(LivingDeathEvent event) {
        Block imperiaCrop;
        BlockPos cropPos;
        World world;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemAnkh.saveAnkhItems(player);
            NBTTagCompound tag = player.getEntityData();
            if (tag.func_74764_b("hasSacrificed") && !tag.func_74767_n("hasSacrificed")) {
                EntityItem ei = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, new ItemStack(UCItems.heart));
                tag.func_74757_a("hasSacrificed", true);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)ei);
                }
                return;
            }
        } else if (event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false) && event.getEntityLiving().getEntityData().func_74764_b("ImperiaPosTag") && event.getEntityLiving().getEntityData().func_74764_b("ImperiaStage") && !(world = event.getEntityLiving().field_70170_p).func_175623_d(cropPos = NBTUtil.func_186861_c((NBTTagCompound)event.getEntityLiving().getEntityData().func_74775_l("ImperiaPosTag"))) && world.func_175667_e(cropPos) && (imperiaCrop = world.func_180495_p(cropPos).func_177230_c()) == UCBlocks.cropImperia && !world.field_72995_K) {
            int stage = event.getEntityLiving().getEntityData().func_74762_e("ImperiaStage");
            ((Imperia)imperiaCrop).advanceStage(world, cropPos, world.func_180495_p(cropPos), stage);
        }
    }

    @SubscribeEvent
    public void checkDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityChicken) {
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                EntityChicken chicken = (EntityChicken)event.getEntityLiving();
                NBTTagCompound tag = chicken.getEntityData();
                if (!chicken.func_70631_g_() && tag.func_74764_b(ItemGeneric.TAG_OVERCLUCK)) {
                    this.addDrop(event, EnumItems.EGGUPGRADE.createStack());
                }
            }
        } else if (!(event.getEntityLiving() instanceof EntityPlayer) && event.getSource().func_76346_g() instanceof EntityPlayer) {
            ItemStack axe;
            EntityLiving el = (EntityLiving)event.getEntityLiving();
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            EntityEquipmentSlot[] slot = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET};
            ItemStack boots = el.func_184582_a(slot[0]);
            if (!boots.func_190926_b() && player.field_71071_by.func_70431_c(EnumItems.SLIPPER.createStack()) && player.field_70170_p.field_73012_v.nextInt(5) == 0) {
                this.addDrop(event, new ItemStack((Item)UCItems.slippers));
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack oneboot = player.field_71071_by.func_70301_a(i);
                    if (oneboot.func_190926_b() || oneboot.func_77973_b() != UCItems.generic || oneboot.func_77952_i() != 14) continue;
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    break;
                }
            }
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == UCItems.precisionAxe && ((IBookUpgradeable)(axe = player.func_184614_ca()).func_77973_b()).isMaxLevel(axe)) {
                Random rand = el.field_70170_p.field_73012_v;
                int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                if (rand.nextInt(15) <= 2 + looting) {
                    if (el instanceof EntitySkeleton) {
                        this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 0));
                    }
                    if (el instanceof EntityWitherSkeleton) {
                        this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 1));
                    }
                    if (el instanceof EntityZombie) {
                        this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 2));
                    }
                    if (el instanceof EntityCreeper) {
                        this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 4));
                    }
                }
            }
        }
    }

    private void addDrop(LivingDropsEvent event, ItemStack drop) {
        EntityItem ei = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, drop);
        ei.func_174867_a(10);
        event.getDrops().add(ei);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && !event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            EntityPlayer oldPlayer = event.getOriginal();
            EntityPlayer newPlayer = event.getEntityPlayer();
            ItemAnkh.putAnkhItems(oldPlayer, newPlayer);
            NBTTagCompound oldtag = oldPlayer.getEntityData();
            NBTTagCompound tag = newPlayer.getEntityData();
            if (oldtag.func_74764_b("UC_FeroxiaGrowth")) {
                tag.func_74782_a("UC_FeroxiaGrowth", (NBTBase)oldtag.func_150295_c("UC_FeroxiaGrowth", 10).func_74737_b());
            }
            if (oldtag.func_74764_b("hasSacrificed")) {
                tag.func_74757_a("hasSacrificed", oldtag.func_74767_n("hasSacrificed"));
            }
            if (oldtag.func_74764_b("UC_tagAbstractGrowth")) {
                tag.func_74768_a("UC_tagAbstractGrowth", oldtag.func_74762_e("UC_tagAbstractGrowth"));
            }
        }
    }

    @SubscribeEvent
    public void checkSetTarget(LivingSetAttackTargetEvent event) {
        boolean flag;
        if (event.getTarget() == null) {
            return;
        }
        if (!(event.getTarget() instanceof EntityPlayer) || event.getTarget() instanceof FakePlayer) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getTarget();
        EntityLiving ent = (EntityLiving)event.getEntity();
        boolean bl = flag = !((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b() == UCItems.poncho && ((IBookUpgradeable)((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b()).getLevel((ItemStack)player.field_71071_by.field_70460_b.get(2)) == 10;
        if (flag && ent.func_184222_aU() && !(ent instanceof EntityGuardian) && !(ent instanceof EntityShulker)) {
            ent.func_70624_b(null);
            ent.func_70604_c(null);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        BlockPos pos;
        Block cactus;
        EntityPlayer player;
        ItemStack brassKnuckles;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityLivingBase && event.getSource().func_76364_f() instanceof EntityPlayer && (brassKnuckles = (player = (EntityPlayer)event.getSource().func_76364_f()).func_184614_ca()).func_77973_b() == UCItems.brassKnuckles) {
            boolean flag;
            boolean bl = flag = NBTUtils.getList(brassKnuckles, "UC:hitList", 10, true) != null && NBTUtils.getList(brassKnuckles, "UC:hitList", 10, true).func_82582_d();
            if (!flag) {
                return;
            }
            float damage = event.getAmount();
            ItemBrassKnuckles.addHitEntity(event.getEntityLiving(), brassKnuckles, player.field_70170_p.func_82737_E(), damage);
            event.setCanceled(true);
            BlockPos pos2 = event.getEntityLiving().func_180425_c();
            UCPacketHandler.sendToNearbyPlayers(player.field_70170_p, player.func_180425_c(), new PacketUCEffect(EnumParticleTypes.CRIT, (double)pos2.func_177958_n() - 0.5, (double)pos2.func_177956_o() + 0.2, (double)pos2.func_177952_p() - 0.5, 6));
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        player = (EntityPlayer)event.getEntityLiving();
        if (event.getSource().func_76364_f() instanceof EntityLiving) {
            EntityLiving el = (EntityLiving)event.getSource().func_76364_f();
            ItemStack pants = (ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.LEGS.func_188454_b());
            if (!pants.func_190926_b() && pants.func_77973_b() == UCItems.thunderPantz) {
                ItemThunderpants pantz = (ItemThunderpants)pants.func_77973_b();
                if (pantz.getCharge(pants) < 1.0f) {
                    return;
                }
                event.setCanceled(true);
                float toDamage = pantz.getCharge(pants);
                player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(el.field_70170_p, el.field_70165_t, el.field_70163_u, el.field_70161_v, true));
                el.func_70097_a(DamageSource.field_180137_b, toDamage);
                pantz.setCharge(pants, 0.0f);
                return;
            }
        }
        if (event.getSource() == DamageSource.field_76380_i && player.field_70170_p.field_73011_w.getDimension() == UCDimension.dimID) {
            event.setCanceled(true);
            player.changeDimension(0, (ITeleporter)new CropWorldTeleporter());
            return;
        }
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.FEET.func_188454_b());
        if (!boots.func_190926_b() && boots.func_77973_b() == UCItems.slippers && (cactus = player.field_70170_p.func_180495_p(pos = new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), player.func_180425_c().func_177977_b().func_177956_o(), MathHelper.func_76128_c((double)player.field_70161_v))).func_177230_c()) != null && cactus == Blocks.field_150434_aF) {
            event.setCanceled(true);
        }
        if (event.getSource() != DamageSource.field_76376_m && event.getSource().func_76346_g() instanceof EntityLiving) {
            EntityLivingBase elb = (EntityLivingBase)event.getSource().func_76346_g();
            for (TileEntity tile : event.getEntityLiving().field_70170_p.field_147482_g) {
                EntityLivingBase tagged;
                if (!(tile instanceof TileGoblet) || (tagged = UCUtils.getTaggedEntity(((TileGoblet)tile).entityId)) == null) continue;
                event.setCanceled(true);
                tagged.func_70097_a(event.getSource(), event.getAmount());
                if (!tagged.func_70089_S()) {
                    ((TileGoblet)tile).eraseTaglock();
                }
                return;
            }
            for (int i = 0; i < 4; ++i) {
                if (!this.hasCactusArmorPiece(player, i)) continue;
                float damage = event.getAmount();
                elb.func_70097_a(DamageSource.field_76367_g, damage);
                return;
            }
            ItemStack activeStack = player.func_184607_cu();
            if (!activeStack.func_190926_b() && activeStack.func_77973_b() == UCItems.impactShield) {
                ((ItemImpactShield)activeStack.func_77973_b()).damageImpactShield(player, activeStack, event.getAmount());
                event.setCanceled(true);
            }
        }
    }

    private boolean hasCactusArmorPiece(EntityPlayer player, int i) {
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (i) {
            case 3: {
                return stack.func_77973_b() == UCItems.cactusHelm;
            }
            case 2: {
                return stack.func_77973_b() == UCItems.cactusPlate;
            }
            case 1: {
                return stack.func_77973_b() == UCItems.cactusLeggings;
            }
            case 0: {
                return stack.func_77973_b() == UCItems.cactusBoots;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void maximumOvercluck(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityChicken) {
            EntityChicken chicken = (EntityChicken)event.getEntityLiving();
            NBTTagCompound tag = chicken.getEntityData();
            if (!chicken.func_70631_g_() && tag.func_74764_b(ItemGeneric.TAG_OVERCLUCK)) {
                int timer = tag.func_74762_e(ItemGeneric.TAG_OVERCLUCK);
                tag.func_74768_a(ItemGeneric.TAG_OVERCLUCK, --timer);
                if (--timer <= 0) {
                    chicken.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (chicken.field_70170_p.field_73012_v.nextFloat() - chicken.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    chicken.func_145779_a(Items.field_151110_aK, 1);
                    timer = chicken.field_70170_p.field_73012_v.nextInt(60) + 900;
                    tag.func_74768_a(ItemGeneric.TAG_OVERCLUCK, timer);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean flag;
        if (event.getPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b() == UCItems.pixelGlasses && (flag = NBTUtils.getBoolean((ItemStack)player.field_71071_by.field_70460_b.get(3), "isActive", false)) && event.getState().func_177230_c() == Blocks.field_150348_b && UCOreHandler.getInstance().getSaveInfo().containsValue(event.getPos())) {
            EntityItem ei = new EntityItem(event.getWorld(), (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, new ItemStack(UCItems.diamonds));
            if (!event.getWorld().field_72995_K) {
                event.getWorld().func_72838_d((Entity)ei);
            }
            UCOreHandler.getInstance().removeChunk(event.getPos(), true);
            ((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77972_a(10, (EntityLivingBase)player);
            return;
        }
        boolean bl = flag = player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == UCItems.precisionPick;
        if (!flag) {
            return;
        }
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == UCItems.precisionPick) {
            if (((IBookUpgradeable)player.func_184614_ca().func_77973_b()).getLevel(player.func_184614_ca()) < 10) {
                return;
            }
            if (event.getState().func_177230_c() == Blocks.field_150418_aU) {
                event.setCanceled(true);
                event.getWorld().func_175698_g(event.getPos());
                EntityItem ei = new EntityItem(event.getWorld(), (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, new ItemStack(event.getState().func_177230_c()));
                if (!event.getWorld().field_72995_K) {
                    event.getWorld().func_72838_d((Entity)ei);
                }
                if (player instanceof EntityPlayerMP) {
                    player.func_184614_ca().func_96631_a(1, event.getWorld().field_73012_v, (EntityPlayerMP)player);
                }
                return;
            }
            if (event.getState().func_177230_c() == Blocks.field_150474_ac) {
                event.setCanceled(true);
                TileEntity tile = event.getWorld().func_175625_s(event.getPos());
                if (tile instanceof TileEntityMobSpawner) {
                    ItemStack stack = new ItemStack(Blocks.field_150474_ac);
                    if (!event.getWorld().field_72995_K) {
                        NBTUtils.setCompound(stack, "Spawner", ((TileEntityMobSpawner)tile).serializeNBT());
                        EntityItem ei = new EntityItem(event.getWorld(), (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, stack);
                        event.getWorld().func_72838_d((Entity)ei);
                    }
                    event.getWorld().func_175698_g(event.getPos());
                    if (player instanceof EntityPlayerMP) {
                        player.func_184614_ca().func_96631_a(1, event.getWorld().field_73012_v, (EntityPlayerMP)player);
                    }
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void placeMobSpawner(BlockEvent.PlaceEvent event) {
        if (event.getState().func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        ItemStack spawner = event.getItemInHand();
        if (spawner.func_77942_o() && spawner.func_77978_p().func_74764_b("Spawner") && Block.func_149634_a((Item)spawner.func_77973_b()) == Blocks.field_150474_ac) {
            TileEntity tile = TileEntity.func_190200_a((World)event.getWorld(), (NBTTagCompound)spawner.func_77978_p().func_74775_l("Spawner"));
            event.getWorld().func_175690_a(event.getPos(), tile);
        }
    }

    @SubscribeEvent
    public void onBlockFall(EntityJoinWorldEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityFallingBlock && (player = event.getEntity().field_70170_p.func_72890_a(event.getEntity(), (double)this.range)) != null && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == UCItems.precisionShovel && ((IBookUpgradeable)player.func_184614_ca().func_77973_b()).getLevel(player.func_184614_ca()) == 10) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Random rand;
        EntityPlayer player = event.player;
        ItemStack pixelGlasses = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (!pixelGlasses.func_190926_b() && pixelGlasses.func_77973_b() == UCItems.pixelGlasses) {
            boolean flag = NBTUtils.getBoolean(pixelGlasses, "isActive", false);
            boolean flag2 = ((IBookUpgradeable)UCItems.pixelGlasses).isMaxLevel(pixelGlasses);
            if (flag && flag2 && event.phase == TickEvent.Phase.START && player.field_70170_p.func_82737_E() % 20L == 0L) {
                ChunkPos cPos = new ChunkPos(player.func_180425_c());
                if (UCOreHandler.getInstance().getSaveInfo().containsKey(cPos)) {
                    BlockPos pos = UCOreHandler.getInstance().getSaveInfo().get(cPos);
                    NBTUtils.setLong(pixelGlasses, "orePos", pos.func_177986_g());
                }
                if (!event.side.isClient() && !UCOreHandler.getInstance().getSaveInfo().containsKey(cPos)) {
                    NBTUtils.setLong(pixelGlasses, "orePos", BlockPos.field_177992_a.func_177986_g());
                }
            }
            if (event.side.isClient() && FMLClientHandler.instance().getClientPlayerEntity().func_70005_c_().equals(player.func_70005_c_())) {
                if (flag) {
                    UniqueCrops.proxy.enableBitsShader();
                } else {
                    UniqueCrops.proxy.disableBitsShader();
                }
            }
        } else if ((((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_190926_b() || !((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b() == UCItems.pixelGlasses) && event.side.isClient()) {
            UniqueCrops.proxy.disableBitsShader();
        }
        if (player.getEntityData().func_74764_b("UC_tagAbstractGrowth") && event.phase == TickEvent.Phase.START && player.field_70170_p.field_73012_v.nextInt(1000) == 0 && (rand = new Random()).nextInt(10) != 0) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)EnumItems.ABSTRACT.createStack());
            if (!event.player.field_70170_p.field_72995_K) {
                SeedBehavior.setAbstractCropGrowth(event.player, -1);
            }
        }
    }

    @SubscribeEvent
    public void onEnderpearl(EnderTeleportEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (event.getAttackDamage() > 0.0f && !event.getEntityLiving().field_70170_p.field_72995_K) {
            BlockPos pos = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            Iterable posList = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2));
            for (BlockPos loopPos : posList) {
                if (event.getEntityLiving().field_70170_p.func_175623_d(loopPos) || event.getEntityLiving().field_70170_p.func_180495_p(loopPos).func_177230_c() != UCBlocks.cropEnderlily) continue;
                Enderlily lily = (Enderlily)event.getEntityLiving().field_70170_p.func_180495_p(loopPos).func_177230_c();
                lily.isEnderLilyGrown(event.getEntityLiving().field_70170_p, loopPos, event.getEntityLiving().field_70170_p.func_180495_p(loopPos));
                break;
            }
        }
    }

    @SubscribeEvent
    public void onSpawnerSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawner() == null || event.getWorld().func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        if (event.getWorld().field_73011_w.func_177495_o()) {
            if (!UCConfig.witherSkeletonSpawner) {
                return;
            }
            if (event.getEntityLiving() instanceof EntitySkeleton && event.getWorld().field_73012_v.nextInt(4) > 1) {
                EntityWitherSkeleton skeleton = new EntityWitherSkeleton(event.getWorld());
                skeleton.func_70107_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                event.getWorld().func_72838_d((Entity)skeleton);
                event.getEntity().func_70106_y();
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onCropGrowth(BlockEvent.CropGrowEvent.Pre event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        List players = event.getWorld().func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos.func_177982_a(-7, -3, -7), pos.func_177982_a(7, 3, 7)));
        for (EntityPlayer player : players) {
            CPCapability cap;
            int range;
            ItemStack itemCap = player.func_184614_ca();
            ItemStack offhand = player.func_184592_cb();
            int distance = (int)player.func_174831_c(event.getPos());
            if (distance > (range = offhand.func_77973_b() instanceof IItemBooster ? 4 + ((IItemBooster)offhand.func_77973_b()).getRange(offhand) : 3) || (cap = (CPCapability)itemCap.getCapability(CPProvider.CROP_POWER, null)) == null || !cap.canAdd()) continue;
            int extraPower = offhand.func_77973_b() instanceof IItemBooster ? ((IItemBooster)offhand.func_77973_b()).getPower(offhand) : 0;
            cap.add(1 + extraPower);
            if (player instanceof EntityPlayerMP) {
                UCPacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncCap(cap.serializeNBT()), (EntityPlayerMP)player);
            }
            event.setResult(Event.Result.DENY);
        }
        if (event.getState().func_177230_c() != Blocks.field_150464_aj) {
            return;
        }
        TileEntity tile = UCUtils.getClosestTile(TileDigger.class, event.getWorld(), event.getPos(), 8.0);
        if (tile instanceof TileDigger) {
            if (((TileDigger)tile).isJobDone()) {
                event.setResult(Event.Result.DEFAULT);
                return;
            }
            boolean flag = ((TileDigger)tile).digBlock(event.getWorld());
            if (flag) {
                event.setResult(Event.Result.DENY);
            } else {
                event.setResult(Event.Result.DEFAULT);
            }
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        List<MultiblockPattern> patterns = UCConfig.getPatterns();
        if (patterns.isEmpty()) {
            return;
        }
        for (MultiblockPattern pattern : patterns) {
            ActionResult<Set<BlockPos>> matched;
            IBlockState state;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack held = player.func_184586_b(event.getHand());
            if (!ItemStack.func_179545_c((ItemStack)held, (ItemStack)pattern.getCatalyst()) || !pattern.isOriginBlock(state = event.getWorld().func_180495_p(event.getPos())) || (matched = pattern.match(event.getWorld(), event.getPos())).func_188397_a() != EnumActionResult.SUCCESS) continue;
            int cropPower = pattern.getPower();
            CPCapability cap = (CPCapability)held.getCapability(CPProvider.CROP_POWER, null);
            if (cropPower > 0) {
                int power;
                int n = power = cap != null ? cap.getPower() : 0;
                if (power < cropPower) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Insufficient crop power. Needed: " + cropPower), true);
                    return;
                }
            }
            if (cropPower > 0 && !event.getWorld().field_72995_K && player instanceof EntityPlayerMP && !player.field_71075_bZ.field_75098_d) {
                cap.remove(cropPower);
                UCPacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncCap(cap.serializeNBT()), (EntityPlayerMP)player);
            }
            if (cropPower <= 0 && !event.getWorld().field_72995_K && !player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            pattern.setResult(event.getWorld(), event.getPos());
            event.setCanceled(true);
            player.func_184609_a(event.getHand());
            break;
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        EntityItem eventEntity = event.getEntityItem();
        if (eventEntity.func_92059_d().func_77973_b() == UCItems.diamonds && !event.getPlayer().field_71075_bZ.field_75098_d) {
            event.setCanceled(true);
            ItemStack eventStack = eventEntity.func_92059_d().func_77946_l();
            eventStack.func_77972_a(1, (EntityLivingBase)event.getPlayer());
            if (!event.getEntity().field_70170_p.field_72995_K) {
                int num = 1;
                if (eventStack.func_77952_i() <= event.getEntityItem().func_92059_d().func_77958_k() - 1) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getPlayer(), (ItemStack)eventStack);
                } else {
                    num = 2;
                }
                EntityItem diamonds = new EntityItem(event.getPlayer().field_70170_p, (double)eventEntity.func_180425_c().func_177958_n() + 0.5, (double)eventEntity.func_180425_c().func_177956_o() + 0.5, (double)eventEntity.func_180425_c().func_177952_p() + 0.5, new ItemStack(Items.field_151045_i, num));
                diamonds.func_174869_p();
                event.getPlayer().field_70170_p.func_72838_d((Entity)diamonds);
            }
        }
    }

    @SubscribeEvent
    public void onPressurePlateTrigger(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150456_au && ((Boolean)event.getState().func_177229_b((IProperty)BlockPressurePlate.field_176580_a)).booleanValue()) {
            for (BlockPos loopPos : Itero.PLATES) {
                TileEntity tile = event.getWorld().func_175625_s(event.getPos().func_177973_b((Vec3i)loopPos));
                if (!(tile instanceof TileItero)) continue;
                ((TileItero)tile).matchCombo(event.getPos());
                break;
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool = event.getTable().getPool("main");
        if (pool == null) {
            pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(5.0f, 10.0f), new RandomValueRange(0.0f), "main");
            event.getTable().addPool(pool);
        }
        if (event.getName().equals((Object)LootTableList.field_191192_o)) {
            pool.addEntry((LootEntry)new LootEntryItem(UCItems.seedsBlessed, 10, 0, new LootFunction[0], new LootCondition[0], "uniquecrops:" + UCItems.seedsBlessed.func_77658_a()));
            pool.addEntry((LootEntry)new LootEntryItem(UCItems.potionEnnui, 20, 0, new LootFunction[0], new LootCondition[0], "uniquecrops:" + UCItems.potionEnnui.func_77658_a()));
        }
    }

    @SubscribeEvent
    public void advancementEvent(AdvancementEvent event) {
        if (!event.getAdvancement().func_192067_g().toString().equals("uniquecrops:main/wildwoodstaff_craft")) {
            return;
        }
        if (event.getEntityPlayer().field_71071_by.func_70431_c(new ItemStack(UCItems.bookMultiblock))) {
            return;
        }
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getEntityPlayer(), (ItemStack)new ItemStack(UCItems.bookMultiblock));
    }

    public void getCollisions(GetCollisionBoxesEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.func_70093_af()) {
            AxisAlignedBB playerBB = player.func_174813_aQ();
            World world = event.getWorld();
            for (BlockPos.MutableBlockPos loopPos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)playerBB.field_72340_a), (int)MathHelper.func_76128_c((double)(playerBB.field_72338_b - 1.0)), (int)MathHelper.func_76128_c((double)playerBB.field_72339_c), (int)MathHelper.func_76128_c((double)playerBB.field_72340_a), (int)MathHelper.func_76128_c((double)playerBB.field_72338_b), (int)MathHelper.func_76128_c((double)playerBB.field_72339_c))) {
                IBlockState state = world.func_180495_p((BlockPos)loopPos);
                if (!state.func_185904_a().func_76220_a()) continue;
                event.getCollisionBoxesList().clear();
            }
        }
    }

    private ItemStack updateRepairOutput(ItemStack input1, ItemStack input2) {
        ItemStack itemstack = input1;
        int maximumCost = 1;
        int materialCost = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack1 = itemstack.func_77946_l();
        ItemStack itemstack2 = input2;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)itemstack1);
        j = j + itemstack.func_82838_A() + (itemstack2 == null ? 0 : itemstack2.func_82838_A());
        materialCost = 0;
        boolean flag = false;
        if (!itemstack2.func_190926_b()) {
            boolean bl = flag = itemstack2.func_77973_b() == Items.field_151134_bR && !EnchantmentHelper.func_82781_a((ItemStack)itemstack2).isEmpty();
            if (itemstack1.func_77984_f() && itemstack1.func_77973_b().func_82789_a(itemstack, itemstack2)) {
                int k2;
                int j2 = Math.min(itemstack1.func_77952_i(), itemstack1.func_77958_k() / 4);
                if (j2 <= 0) {
                    return ItemStack.field_190927_a;
                }
                for (k2 = 0; j2 > 0 && k2 < itemstack2.func_190916_E(); ++k2) {
                    int l2 = itemstack1.func_77952_i() - j2;
                    itemstack1.func_77964_b(l2);
                    ++i;
                    j2 = Math.min(itemstack1.func_77952_i(), itemstack1.func_77958_k() / 4);
                }
                materialCost = k2;
            } else {
                if (!(flag || itemstack1.func_77973_b() == itemstack2.func_77973_b() && itemstack1.func_77984_f())) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_77984_f() && !flag) {
                    int l = itemstack.func_77958_k() - itemstack.func_77952_i();
                    int i1 = itemstack2.func_77958_k() - itemstack2.func_77952_i();
                    int j1 = i1 + itemstack1.func_77958_k() * 12 / 100;
                    int k1 = l + j1;
                    int l1 = itemstack1.func_77958_k() - k1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (l1 < itemstack1.func_77960_j()) {
                        itemstack1.func_77964_b(l1);
                        i += 2;
                    }
                }
                Map map1 = EnchantmentHelper.func_82781_a((ItemStack)itemstack2);
                for (Enchantment enchantment1 : map1.keySet()) {
                    if (enchantment1 == null) continue;
                    int i3 = map.containsKey(enchantment1) ? (Integer)map.get(enchantment1) : 0;
                    int j3 = (Integer)map1.get(enchantment1);
                    j3 = i3 == j3 ? j3 + 1 : Math.max(j3, i3);
                    boolean flag1 = enchantment1.func_92089_a(itemstack);
                    if (itemstack.func_77973_b() == Items.field_151134_bR) {
                        flag1 = true;
                    }
                    for (Enchantment enchantment : map.keySet()) {
                        if (enchantment == enchantment1 || enchantment1.func_191560_c(enchantment) && enchantment.func_191560_c(enchantment1)) continue;
                        flag1 = false;
                        ++i;
                    }
                    if (!flag1) continue;
                    if (j3 > enchantment1.func_77325_b()) {
                        j3 = enchantment1.func_77325_b();
                    }
                    map.put(enchantment1, j3);
                    int k3 = 0;
                    switch (enchantment1.func_77324_c()) {
                        case COMMON: {
                            k3 = 1;
                            break;
                        }
                        case UNCOMMON: {
                            k3 = 2;
                            break;
                        }
                        case RARE: {
                            k3 = 4;
                            break;
                        }
                        case VERY_RARE: {
                            k3 = 8;
                        }
                    }
                    if (flag) {
                        k3 = Math.max(1, k3 / 2);
                    }
                    i += k3 * j3;
                }
            }
        }
        if (flag && !itemstack1.func_77973_b().isBookEnchantable(itemstack1, itemstack2)) {
            itemstack1 = ItemStack.field_190927_a;
        }
        maximumCost = j + i;
        if (i <= 0) {
            itemstack1 = ItemStack.field_190927_a;
        }
        if (k == i && k > 0 && maximumCost >= 40) {
            maximumCost = 39;
        }
        if (maximumCost >= 40 && maximumCost - 5 >= 40) {
            itemstack1 = ItemStack.field_190927_a;
        }
        if (!itemstack1.func_190926_b()) {
            int i2 = itemstack1.func_82838_A();
            if (!itemstack2.func_190926_b() && i2 < itemstack2.func_82838_A()) {
                i2 = itemstack2.func_82838_A();
            }
            if (k != i || k == 0) {
                i2 = i2 * 2 + 1;
            }
            itemstack1.func_82841_c(i2);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemstack1);
        }
        this.setCost(maximumCost);
        return itemstack1;
    }

    private void setCost(int cost) {
        this.cost = cost;
    }

    private boolean checkNBT(ItemStack input) {
        return NBTUtils.getBoolean(input, ItemGeneric.TAG_DISCOUNT, false);
    }
}

