/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.gui;

import com.bafomdad.uniquecrops.capabilities.CPCapability;
import com.bafomdad.uniquecrops.capabilities.CPProvider;
import com.bafomdad.uniquecrops.core.UCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiStaffOverlay
extends Gui {
    Minecraft mc;
    private static final ResourceLocation TEX = new ResourceLocation("uniquecrops", "textures/gui/leaf_bar.png");
    long lastSystemTime;
    long staffUpdateCounter;
    long updateCounter;
    int capacity;

    public GuiStaffOverlay(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        Profiler profiler = this.mc.field_71424_I;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            boolean flag;
            if (this.mc.field_71462_r != null && this.mc.field_71462_r instanceof GuiChat) {
                return;
            }
            profiler.func_76320_a("UC-hud");
            CPCapability cap = (CPCapability)this.mc.field_71439_g.func_184614_ca().getCapability(CPProvider.CROP_POWER, null);
            if (cap == null) {
                profiler.func_76319_b();
                return;
            }
            ScaledResolution scaled = new ScaledResolution(this.mc);
            int i = cap.getPower();
            boolean bl = flag = this.staffUpdateCounter > this.updateCounter;
            if (flag) {
                GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glDisable((int)2896);
            float scale = (float)Math.sin((double)Minecraft.func_71386_F() / 500.0) * 0.015625f;
            GlStateManager.func_179094_E();
            if (i < this.capacity) {
                this.lastSystemTime = Minecraft.func_71386_F();
                this.staffUpdateCounter = this.updateCounter + 200L;
            }
            if (i > this.capacity) {
                this.lastSystemTime = Minecraft.func_71386_F();
                this.staffUpdateCounter = this.updateCounter + 200L;
            }
            if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
                this.capacity = i;
                this.lastSystemTime = Minecraft.func_71386_F();
            }
            GlStateManager.func_179152_a((float)(1.0f + scale), (float)(1.0f + scale), (float)(1.0f + scale));
            this.renderLeafBar(scaled, cap.getPower(), cap.getCapacity());
            GlStateManager.func_179121_F();
            this.capacity = i;
            profiler.func_76319_b();
        }
        ++this.updateCounter;
    }

    private void renderLeafBar(ScaledResolution res, int currentPower, int capacity) {
        if (capacity <= 0) {
            return;
        }
        int x = res.func_78326_a() / 2 + UCConfig.guiWidth;
        int y = res.func_78328_b() + UCConfig.guiHeight;
        this.mc.field_71446_o.func_110577_a(TEX);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int count = 5;
        if (capacity < count) {
            count = capacity;
        }
        double start = 1.5707963267948966;
        int direction = -1;
        int radius = 15;
        double interval = Math.PI * 2 / (double)count;
        int mod = capacity / count;
        for (int i = 0; i < count; ++i) {
            double angle = start + (double)i * interval * (double)(direction < 0 ? -1 : 1);
            double r1 = (double)radius * Math.cos(angle);
            double r2 = (double)radius * Math.sin(angle);
            this.func_73729_b((int)r1 + x, (int)r2 + y, 0, 0, 15, 15);
            if (i < currentPower / mod) {
                this.func_73729_b((int)r1 + x, (int)r2 + y, 15, 0, 15, 15);
            }
            if (i * mod + capacity / (count * 2) > currentPower) continue;
            this.func_73729_b((int)r1 + x, (int)r2 + y, 30, 0, 15, 15);
        }
        GlStateManager.func_179084_k();
    }

    private float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }
}

