/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.init;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.blocks.BlockCropsBase;
import com.bafomdad.uniquecrops.blocks.BlockDemoCord;
import com.bafomdad.uniquecrops.blocks.BlockLavaLily;
import com.bafomdad.uniquecrops.blocks.itemblocks.ItemBlockBucketRope;
import com.bafomdad.uniquecrops.blocks.itemblocks.ItemBlockLeaves;
import com.bafomdad.uniquecrops.blocks.itemblocks.ItemBlockLily;
import com.bafomdad.uniquecrops.blocks.itemblocks.ItemBlockSunBlock;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.crafting.DiscountBookRecipe;
import com.bafomdad.uniquecrops.entities.EntityBattleCrop;
import com.bafomdad.uniquecrops.entities.EntityCustomPotion;
import com.bafomdad.uniquecrops.entities.EntityEulaBook;
import com.bafomdad.uniquecrops.entities.EntityItemCooking;
import com.bafomdad.uniquecrops.entities.EntityItemDonk;
import com.bafomdad.uniquecrops.entities.EntityItemHourglass;
import com.bafomdad.uniquecrops.entities.EntityItemWeepingEye;
import com.bafomdad.uniquecrops.entities.EntityMirror;
import com.bafomdad.uniquecrops.entities.EntityMovingCrop;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.init.UCPotions;
import com.bafomdad.uniquecrops.init.UCRecipes;
import com.bafomdad.uniquecrops.init.UCSounds;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UCEventRegistry {
    public static int entityID;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        UCBlocks.init();
        for (Block block : UCBlocks.blocks) {
            if (UniqueCrops.charsetLoaded && block instanceof BlockCropsBase && !((BlockCropsBase)block).getCanClickHarvest()) {
                FMLInterModComms.sendMessage((String)"charset", (String)"removeRightClickHarvest", (ResourceLocation)block.getRegistryName());
            }
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        UCItems.init();
        IForgeRegistry reg = event.getRegistry();
        for (Item item : UCItems.items) {
            reg.register((IForgeRegistryEntry)item);
        }
        reg.register((IForgeRegistryEntry)UCItems.edibleBook);
        reg.register(new BlockLavaLily.ItemLavaLily(UCBlocks.lavaLily).setRegistryName(UCBlocks.lavaLily.getRegistryName()));
        reg.register(new ItemBlockLily(UCBlocks.iceLily).setRegistryName(UCBlocks.iceLily.getRegistryName()));
        reg.register(new ItemBlockLily(UCBlocks.teleLily).setRegistryName(UCBlocks.teleLily.getRegistryName()));
        reg.register(new ItemBlockLily(UCBlocks.jungleLily).setRegistryName(UCBlocks.jungleLily.getRegistryName()));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.hourglass));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.oldBrick));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.oldCobble));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.oldCobbleMoss));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.oldGrass));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.oldGravel));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.totemHead));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.darkBlock));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.barrel));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.invisiGlass));
        reg.register(new BlockDemoCord.ItemDemocord(UCBlocks.demoCord).setRegistryName(UCBlocks.demoCord.getRegistryName()));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.mirror));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.goblet));
        reg.register(new ItemBlockSunBlock(UCBlocks.sunBlock).setRegistryName(UCBlocks.sunBlock.getRegistryName()));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.cocito));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.normieCrate));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.driedThatch));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.ruinedBricks));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.ruinedBricksCarved));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.ruinedBricksRed));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.ruinedBricksGhost));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.harvestTrap));
        reg.register(new ItemBlockBucketRope(UCBlocks.bucketRope).setRegistryName(UCBlocks.bucketRope.getRegistryName()));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.flywoodLog));
        reg.register(new ItemBlockLeaves(UCBlocks.flywoodLeaves).setRegistryName(UCBlocks.flywoodLeaves.getRegistryName()));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.flywoodSapling));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.flywoodPlank));
        reg.register((IForgeRegistryEntry)this.rib(UCBlocks.eggBasket));
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new DiscountBookRecipe("discountbook"));
        UCRecipes.init();
        OreDictionary.registerOre((String)"gemDiamond", (Item)UCItems.edibleDiamond);
        OreDictionary.registerOre((String)"gemEmerald", (Item)UCItems.edibleEmerald);
        OreDictionary.registerOre((String)"gemLapis", (Item)UCItems.edibleLapis);
        OreDictionary.registerOre((String)"ingotIron", (Item)UCItems.edibleIngotIron);
        OreDictionary.registerOre((String)"ingotGold", (Item)UCItems.edibleIngotGold);
        OreDictionary.registerOre((String)"nuggetGold", (Item)UCItems.edibleNuggetGold);
        OreDictionary.registerOre((String)"ingotSteel", (Item)UCItems.steelDonut);
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)EnumItems.BLUEDYE.createStack());
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("reversepotion", EntityCustomPotion.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("weepingeye", EntityItemWeepingEye.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("hourglass", EntityItemHourglass.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("eulabook", EntityEulaBook.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("donker", EntityItemDonk.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("mirror", EntityMirror.class, 64, 20, false));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("battlecrop", EntityBattleCrop.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("cookingitem", EntityItemCooking.class));
        event.getRegistry().register((IForgeRegistryEntry)this.entityBuilder("entitymovingcrop", EntityMovingCrop.class));
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)UCSounds.OOF);
        event.getRegistry().register((IForgeRegistryEntry)UCSounds.MUSIC1);
        event.getRegistry().register((IForgeRegistryEntry)UCSounds.MUSIC2);
        event.getRegistry().register((IForgeRegistryEntry)UCSounds.MUSIC3);
        event.getRegistry().register((IForgeRegistryEntry)UCSounds.MUSIC4);
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        UCPotions.init();
        for (Potion p : UCPotions.potions) {
            event.getRegistry().register((IForgeRegistryEntry)p);
        }
    }

    public Item rib(Block block) {
        return (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
    }

    public EntityEntry entityBuilder(String entityName, Class entity) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.name("uniquecrops:" + entityName);
        builder.id(new ResourceLocation("uniquecrops", entityName), entityID++);
        builder.tracker(64, 1, true);
        builder.entity(entity);
        return builder.build();
    }

    public EntityEntry entityBuilder(String entityName, Class entity, int trackingRange, int updateFreq, boolean sendVelocityUpdates) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.name("uniquecrops:" + entityName);
        builder.id(new ResourceLocation("uniquecrops", entityName), entityID++);
        builder.tracker(trackingRange, updateFreq, sendVelocityUpdates);
        builder.entity(entity);
        return builder.build();
    }
}

