/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.proxies;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.core.UCDataFixer;
import com.bafomdad.uniquecrops.entities.EntityMirror;
import com.bafomdad.uniquecrops.events.UCEventHandlerServer;
import com.bafomdad.uniquecrops.events.UCWorldEvents;
import com.bafomdad.uniquecrops.init.UCDimension;
import com.bafomdad.uniquecrops.init.UCEventRegistry;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.integration.IEPlugin;
import com.bafomdad.uniquecrops.items.ItemGoodieBag;
import com.bafomdad.uniquecrops.world.CropIslandGenerator;
import com.bafomdad.uniquecrops.world.RuinsGenerator;
import com.bafomdad.uniquecrops.world.UCOreGen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new UCEventRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new UCWorldEvents());
        UCConfig.init(event);
        UCDimension.init();
        UCDataFixer.init();
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(UCItems.seedsNormal), (int)UCConfig.dropRate);
        if (ItemGoodieBag.isHoliday()) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(UCItems.seedsAdventus), (int)UCConfig.dropRate);
        }
        if (UCConfig.ruinsGeneration) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new RuinsGenerator(), (int)1);
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new CropIslandGenerator(), (int)0);
        MinecraftForge.ORE_GEN_BUS.register((Object)new UCOreGen());
        UCConfig.syncMultiblocks();
    }

    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new UCEventHandlerServer());
        if (UniqueCrops.ieLoaded) {
            try {
                IEPlugin.init();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void initAllModels() {
    }

    public void initEntityRender() {
    }

    public void checkResource() {
    }

    public boolean invisiTrace() {
        return true;
    }

    public void enableBitsShader() {
    }

    public void disableBitsShader() {
    }

    public void killMirror(EntityMirror mirror) {
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public void openEulaBook(EntityPlayer player) {
    }

    public void spawnParticles(EnumParticleTypes particle, double x, double y, double z, int loopSize) {
    }

    public void sparkFX(double x, double y, double z, float r, float g, float b, float size, float motionX, float motionY, float motionZ, float maxAgeMul) {
    }

    public World getClientWorld() {
        return null;
    }
}

