/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.render;

import com.bafomdad.uniquecrops.entities.EntityMirror;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="uniquecrops", value={Side.CLIENT})
public class WorldRenderHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Map<EntityMirror, Integer> textures = Maps.newConcurrentMap();
    public static final List<EntityMirror> pendingRemoval = Lists.newArrayList();
    public static boolean rendering = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTexture(EntityMirror mirror) {
        int quality = 128;
        Map<EntityMirror, Integer> map = textures;
        synchronized (map) {
            int textureID = GlStateManager.func_179146_y();
            GlStateManager.func_179144_i((int)textureID);
            GlStateManager.func_187419_a((int)3553, (int)0, (int)6407, (int)(quality / 2), (int)quality, (int)0, (int)6407, (int)5121, (IntBuffer)BufferUtils.createIntBuffer((int)(3 * (quality / 2) * quality)));
            GlStateManager.func_187403_b((int)3553, (int)10240, (float)9728.0f);
            GlStateManager.func_187403_b((int)3553, (int)10241, (float)9728.0f);
            textures.put(mirror, textureID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasKey(EntityMirror mirror) {
        Map<EntityMirror, Integer> map = textures;
        synchronized (map) {
            return textures.containsKey((Object)mirror);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getValue(EntityMirror mirror) {
        Map<EntityMirror, Integer> map = textures;
        synchronized (map) {
            return textures.get((Object)mirror);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        int quality = 256;
        int yidth = 100 * (quality / 128);
        Map<EntityMirror, Integer> map = textures;
        synchronized (map) {
            if (!pendingRemoval.isEmpty()) {
                for (EntityMirror mirror : pendingRemoval) {
                    if (textures.containsKey((Object)mirror)) {
                        GlStateManager.func_179150_h((int)textures.get((Object)mirror));
                    }
                    textures.remove((Object)mirror);
                }
            }
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            if (WorldRenderHandler.mc.field_71415_G) {
                for (EntityMirror mirror : textures.keySet()) {
                    if (mirror == null) {
                        textures.remove(null);
                        continue;
                    }
                    if (!mirror.func_70089_S()) {
                        pendingRemoval.add(mirror);
                        continue;
                    }
                    if (!mirror.rendering) continue;
                    GameSettings settings = WorldRenderHandler.mc.field_71474_y;
                    int widthBackup = WorldRenderHandler.mc.field_71443_c;
                    int heightBackup = WorldRenderHandler.mc.field_71440_d;
                    int thirdPersonBackup = settings.field_74320_O;
                    boolean hideGuiBackup = settings.field_74319_N;
                    int mipmapBackup = settings.field_151442_I;
                    float fovBackup = settings.field_74334_X;
                    int textureID = textures.get((Object)mirror);
                    settings.field_74320_O = 0;
                    settings.field_74319_N = true;
                    settings.field_151442_I = 3;
                    rendering = true;
                    WorldRenderHandler.mc.field_71443_c = quality * 2;
                    WorldRenderHandler.mc.field_71440_d = quality;
                    mc.func_175607_a((Entity)mirror);
                    EntityRenderer entityRenderer = WorldRenderHandler.mc.field_71460_t;
                    entityRenderer.func_78471_a(event.renderTickTime, System.nanoTime() + 1000000000L / (long)Math.max(30, WorldRenderHandler.mc.field_71474_y.field_74350_i));
                    GlStateManager.func_179144_i((int)textureID);
                    GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)yidth, (int)0, (int)(quality / 2), (int)quality, (int)0);
                    rendering = false;
                    mc.func_175607_a((Entity)WorldRenderHandler.mc.field_71439_g);
                    settings.field_74334_X = fovBackup;
                    settings.field_74320_O = thirdPersonBackup;
                    settings.field_74319_N = hideGuiBackup;
                    settings.field_151442_I = mipmapBackup;
                    WorldRenderHandler.mc.field_71443_c = widthBackup;
                    WorldRenderHandler.mc.field_71440_d = heightBackup;
                    mirror.rendering = false;
                }
            }
        }
    }
}

