/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.world;

import com.bafomdad.uniquecrops.core.UCConfig;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;

public class RuinsGenerator
implements IWorldGenerator {
    public static final ResourceLocation RUINS_STRUCTURE = new ResourceLocation("uniquecrops", "cropruins");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        if (!(world instanceof WorldServer) || world.field_73011_w.getDimension() != 0) {
            return;
        }
        WorldServer serverWorld = (WorldServer)world;
        int x = chunkX * 16 + random.nextInt(8);
        BlockPos pos = new BlockPos(x, 10, z = chunkZ * 16 + random.nextInt(8));
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && random.nextInt(UCConfig.worldGenerationRuinsWeight) == 0) {
            this.generateRuins(serverWorld, random, pos);
        }
    }

    public void generateRuins(WorldServer world, Random rand, BlockPos pos) {
        MinecraftServer server = world.func_73046_m();
        Template template = world.func_184163_y().func_186237_a(server, RUINS_STRUCTURE);
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.values()[rand.nextInt(Rotation.values().length)]);
        template.func_186253_b((World)world, pos, settings);
    }
}

