/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.blocks.BlockBaseUC;
import com.bafomdad.uniquecrops.blocks.tiles.TileGoblet;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGoblet
extends BlockBaseUC {
    public static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");
    private final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625);

    public BlockGoblet() {
        super("goblet", Material.field_151571_B);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.3f);
        this.func_149752_b(1.0f);
        GameRegistry.registerTileEntity(TileGoblet.class, (ResourceLocation)new ResourceLocation("uniquecrops", "TileGoblet"));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FILLED});
    }

    public boolean isFilled(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FILLED);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FILLED) != false ? 1 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof EntityItem) || entity instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() != UCItems.vampiricOintment) {
            return;
        }
        if (this.isFilled(state)) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileGoblet)) {
            return;
        }
        ItemStack ointment = ((EntityItem)entity).func_92059_d();
        if (!ointment.func_77942_o() || ointment.func_77942_o() && !ointment.func_77978_p().func_74764_b("UC_tagLock")) {
            return;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)), 3);
            ((TileGoblet)world.func_175625_s(pos)).setTaglock(UUID.fromString(NBTUtils.getString(ointment, "UC_tagLock", "")));
            entity.func_70106_y();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.isFilled(state)) {
            ItemStack stack = player.func_184586_b(hand);
            TileEntity tile = world.func_175625_s(pos);
            if (!stack.func_190926_b() && stack.func_77973_b() == UCItems.vampiricOintment && tile instanceof TileGoblet) {
                boolean flag;
                boolean bl = flag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("UC_tagLock");
                if (!world.field_72995_K && flag) {
                    ((TileGoblet)tile).setTaglock(UUID.fromString(NBTUtils.getString(stack, "UC_tagLock", "")));
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    world.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)), 3);
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        if (this.isFilled(state)) {
            return 15;
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGoblet();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isFilled(state)) {
            double d0 = (float)pos.func_177958_n() + 0.45f;
            double d1 = (float)pos.func_177956_o() + 0.4f;
            double d2 = (float)pos.func_177952_p() + 0.5f;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

