/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.blocks.BlockBaseUC;
import com.bafomdad.uniquecrops.blocks.tiles.TileHarvestTrap;
import com.bafomdad.uniquecrops.core.UCUtils;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHarvestTrap
extends BlockBaseUC {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final AxisAlignedBB TRAP_AABB = new AxisAlignedBB(0.75, 0.0, 0.75, 0.25, 1.25, 0.25);

    public BlockHarvestTrap() {
        super("harvesttrap", Material.field_151575_d);
        this.func_149711_c(0.85f);
        this.func_149752_b(15.0f);
        this.func_149675_a(true);
        GameRegistry.registerTileEntity(TileHarvestTrap.class, (ResourceLocation)new ResourceLocation("uniquecrops", "TileHarvestTrap"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TRAP_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return TRAP_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileHarvestTrap) {
            TileHarvestTrap trap = (TileHarvestTrap)tile;
            if (!trap.hasSpirit() && !trap.isCollected() && player.func_184586_b(hand).func_77973_b() == EnumItems.SPIRIT_BAIT.createStack().func_77973_b()) {
                trap.setBaitPower(3);
                player.func_184586_b(hand).func_190918_g(1);
                return true;
            }
            if (trap.hasSpirit() && !trap.isCollected()) {
                trap.setSpiritTime(100);
                trap.setCollected();
                trap.setBaitPower(0);
                return true;
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileHarvestTrap) {
            if (UCUtils.getClosestTile(TileHarvestTrap.class, world, pos, 10.0) != null) {
                UCPacketHandler.sendToNearbyPlayers(world, pos, new PacketUCEffect(EnumParticleTypes.BARRIER, pos.func_177958_n(), (double)pos.func_177956_o() + 0.75, pos.func_177952_p(), 0));
                return;
            }
            TileHarvestTrap trap = (TileHarvestTrap)tile;
            if (trap.hasSpirit()) {
                return;
            }
            if (rand.nextInt(5 - trap.getBaitPower()) == 0) {
                trap.setSpiritTime(200);
            } else {
                trap.tickCropGrowth();
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileHarvestTrap();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileHarvestTrap trap;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileHarvestTrap && (trap = (TileHarvestTrap)tile).hasSpirit()) {
            float[] color = trap.getSpiritColor();
            UniqueCrops.proxy.sparkFX((double)pos.func_177958_n() + (double)rand.nextInt(3) * 0.1 + 0.5, (double)pos.func_177956_o() + 1.15 + (double)rand.nextInt(2) * 0.1, (double)pos.func_177952_p() + (double)rand.nextInt(3) * 0.1 + 0.5, color[0], color[1], color[2], 0.5f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
    }
}

