/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.UniqueCropsAPI;
import com.bafomdad.uniquecrops.blocks.BlockBaseUC;
import com.bafomdad.uniquecrops.core.UCUtils;
import com.bafomdad.uniquecrops.crafting.HourglassRecipe;
import com.bafomdad.uniquecrops.entities.EntityItemHourglass;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHourglass
extends BlockBaseUC {
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private int range = 3;

    public BlockHourglass() {
        super("hourglass", Material.field_151573_f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175687_A(pos) > 0) {
            Iterable iterpos = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-this.range, -this.range, -this.range), (BlockPos)pos.func_177982_a(this.range, this.range, this.range));
            List<BlockPos> poslist = UCUtils.makeCollection(iterpos, true);
            for (BlockPos looppos : poslist) {
                IBlockState loopState;
                HourglassRecipe recipe;
                boolean flag;
                if (world.field_72995_K || world.func_175623_d(looppos) || !(flag = rand.nextInt(10) == 0) || (recipe = UniqueCropsAPI.HOURGLASS_RECIPE_REGISTRY.findRecipe(loopState = world.func_180495_p(looppos))) == null) continue;
                EntityItemHourglass.convertBlock(world, looppos, recipe.getOutput(), recipe.getOutputMeta());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(2) == 0 && world.func_175687_A(pos) > 0) {
            world.func_175688_a(EnumParticleTypes.END_ROD, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.03, 0.0, new int[0]);
        }
    }

    public static class ItemBlockHourglass
    extends ItemBlock {
        public ItemBlockHourglass(Block block) {
            super(block);
        }

        public boolean hasCustomEntity(ItemStack stack) {
            return true;
        }

        public int getEntityLifespan(ItemStack stack, World world) {
            return Integer.MAX_VALUE;
        }

        public Entity createEntity(World world, Entity location, ItemStack stack) {
            if (location instanceof EntityItem) {
                EntityItemHourglass hourglass = new EntityItemHourglass(world, (EntityItem)location, stack);
                return hourglass;
            }
            return null;
        }
    }
}

