/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.UniqueCropsAPI;
import com.bafomdad.uniquecrops.blocks.tiles.TileBaseRenderUC;
import com.bafomdad.uniquecrops.crafting.EnchantmentRecipe;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.items.ItemWildwoodStaff;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFascino
extends TileBaseRenderUC
implements ITickable {
    private final BlockPos[] ENCHPOS = new BlockPos[]{new BlockPos(0, 0, 3), new BlockPos(0, 0, -3), new BlockPos(3, 0, 0), new BlockPos(-3, 0, 0), new BlockPos(2, 0, 2), new BlockPos(-2, 0, -2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, 2)};
    private ItemStackHandler inv = new ItemStackHandler(5){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private ItemStack enchantItem = ItemStack.field_190927_a;
    private final int RANGE = 7;
    private Stage stage = Stage.IDLE;
    private UUID enchanterId;
    private int enchantingTicks = 0;
    private int enchantmentCost = 7;
    private boolean showMissingCrops;

    public void func_73660_a() {
        if (this.showMissingCrops) {
            this.loopMissingCrops();
        }
        if (this.stage == Stage.IDLE) {
            return;
        }
        ++this.enchantingTicks;
        this.stage.advance(this);
    }

    public void loopMissingCrops() {
        for (int i = 0; i < this.ENCHPOS.length; ++i) {
            BlockPos loopPos = this.field_174879_c.func_177971_a((Vec3i)this.ENCHPOS[i]);
            IBlockState loopState = this.field_145850_b.func_180495_p(loopPos);
            if (loopState.func_177230_c() == UCBlocks.cropHexis) continue;
            UCPacketHandler.sendToNearbyPlayers(this.field_145850_b, loopPos, new PacketUCEffect(EnumParticleTypes.SMOKE_NORMAL, (double)loopPos.func_177958_n() - 0.5, (double)loopPos.func_177956_o() + 0.1, (double)loopPos.func_177952_p() - 0.5, 4));
        }
    }

    public void checkEnchants(EntityPlayer player, ItemStack staff) {
        ItemStack heldItem = ItemStack.field_190927_a;
        this.showMissingCrops = false;
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_190926_b() || !stack.func_77973_b().func_77616_k(stack) || stack.func_77973_b() == UCItems.wildwoodStaff) continue;
            heldItem = stack;
            break;
        }
        if (!heldItem.func_190926_b()) {
            EnchantmentRecipe recipe = UniqueCropsAPI.ENCHANTER_REGISTRY.findRecipe((IItemHandler)this.inv);
            if (recipe != null) {
                if (!recipe.getEnchantment().field_77351_y.func_77557_a(heldItem.func_77973_b())) {
                    player.func_146105_b(new TextComponentTranslation("uniquecrops.enchanting.unenchantable", new Object[0]).func_150258_a(" " + heldItem.func_82833_r()), true);
                    return;
                }
                if (EnchantmentHelper.func_82781_a((ItemStack)heldItem).containsKey(recipe.getEnchantment())) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.enchantmentexists", new Object[0]), true);
                    return;
                }
                Map enchantSet = EnchantmentHelper.func_82781_a((ItemStack)heldItem);
                Set enchantments = enchantSet.keySet();
                for (Enchantment ench : enchantments) {
                    if (ench.func_191560_c(recipe.getEnchantment())) continue;
                    player.func_146105_b(new TextComponentTranslation("uniquecrops.enchanting.incompatible", new Object[0]).func_150258_a(" " + ench.func_77316_c(((Integer)enchantSet.get(ench)).intValue())), true);
                    return;
                }
                this.prepareEnchanting(player, heldItem.func_77986_q().func_74745_c() + 1, staff, recipe.getCost());
                this.enchantItem = heldItem;
                return;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.unknownrecipe", new Object[0]), true);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.nothing", new Object[0]), true);
        }
    }

    private void prepareEnchanting(EntityPlayer player, int enchantmentSize, ItemStack staff, int powerCost) {
        int maxGrowth = 7;
        for (int i = 0; i < this.ENCHPOS.length; ++i) {
            BlockPos loopPos = this.field_174879_c.func_177971_a((Vec3i)this.ENCHPOS[i]);
            IBlockState loopState = this.field_145850_b.func_180495_p(loopPos);
            if (loopState.func_177230_c() == UCBlocks.cropHexis) {
                int age = (Integer)loopState.func_177229_b((IProperty)BlockCrops.field_176488_a);
                if (age >= maxGrowth) continue;
                maxGrowth = age;
                continue;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.missingcrops", new Object[0]), true);
            this.showMissingCrops = true;
            this.enchantItem = ItemStack.field_190927_a;
            return;
        }
        if (maxGrowth < enchantmentSize) {
            player.func_146105_b(new TextComponentTranslation("uniquecrops.enchanting.cropgrowth", new Object[0]).func_150258_a(" " + enchantmentSize), true);
            this.enchantItem = ItemStack.field_190927_a;
            return;
        }
        if (!ItemWildwoodStaff.adjustPower(staff, powerCost)) {
            player.func_146105_b(new TextComponentTranslation("uniquecrops.enchanting.notenoughpower", new Object[0]).func_150258_a(" " + powerCost), true);
            this.enchantItem = ItemStack.field_190927_a;
            return;
        }
        this.stage = Stage.PREPARE;
        this.enchantmentCost = enchantmentSize;
        this.enchanterId = player.func_110124_au();
        this.markBlockForUpdate();
        this.func_70296_d();
    }

    private EntityPlayer getEnchanter() {
        List playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-7, -1, -7), this.field_174879_c.func_177982_a(7, 2, 7)));
        for (EntityPlayer player : playerList) {
            if (!player.func_110124_au().equals(this.enchanterId)) continue;
            return player;
        }
        return null;
    }

    public void advanceEnchanting() {
        EntityPlayer player = this.getEnchanter();
        if (player == null) {
            this.advanceStage();
        }
        for (int i = 0; i < this.ENCHPOS.length; ++i) {
            int age;
            BlockPos loopPos = this.field_174879_c.func_177971_a((Vec3i)this.ENCHPOS[i]);
            IBlockState loopState = this.field_145850_b.func_180495_p(loopPos);
            if (loopState.func_177230_c() == UCBlocks.cropHexis) {
                age = (Integer)loopState.func_177229_b((IProperty)BlockCrops.field_176488_a);
                if (age < 7 - this.enchantmentCost) {
                    this.finishEnchanting();
                    break;
                }
            } else {
                this.advanceStage();
                break;
            }
            this.field_145850_b.func_175718_b(2001, loopPos, Block.func_176210_f((IBlockState)loopState));
            this.field_145850_b.func_175656_a(loopPos, loopState.func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(Math.max(age - 1, 0))));
        }
    }

    private void finishEnchanting() {
        if (this.enchantingTicks < 80) {
            return;
        }
        EntityPlayer player = this.getEnchanter();
        if (player == null) {
            this.advanceStage();
            this.enchantItem = ItemStack.field_190927_a;
            return;
        }
        ItemStack heldItem = ItemStack.field_190927_a;
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_190926_b() || !stack.func_77973_b().func_77616_k(stack) || stack.func_77973_b() == UCItems.wildwoodStaff) continue;
            heldItem = stack;
            break;
        }
        if (heldItem.func_190926_b()) {
            this.advanceStage();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.nothing", new Object[0]), true);
            this.enchantItem = ItemStack.field_190927_a;
            return;
        }
        if (!ItemStack.func_179545_c((ItemStack)heldItem, (ItemStack)this.enchantItem)) {
            this.advanceStage();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.nomatch", new Object[0]), true);
            this.enchantItem = ItemStack.field_190927_a;
            return;
        }
        EnchantmentRecipe recipe = UniqueCropsAPI.ENCHANTER_REGISTRY.findRecipe((IItemHandler)this.inv);
        if (recipe != null) {
            recipe.applyEnchantment(heldItem);
            this.clearInv();
            this.advanceStage();
            this.field_145850_b.func_175718_b(2004, this.func_174877_v().func_177963_a(0.0, 0.7, 0.0), 0);
        } else {
            this.advanceStage();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("uniquecrops.enchanting.unknownrecipe", new Object[0]), true);
        }
        this.enchantItem = ItemStack.field_190927_a;
    }

    public void loopEffects() {
        for (int i = 0; i < this.ENCHPOS.length; ++i) {
            BlockPos loopPos = this.field_174879_c.func_177971_a((Vec3i)this.ENCHPOS[i]);
            IBlockState loopState = this.field_145850_b.func_180495_p(loopPos);
            if (loopState.func_177230_c() != UCBlocks.cropHexis) continue;
            int size = 4;
            for (int j = 0; j < size; ++j) {
                for (int k = 0; k < size; ++k) {
                    double x = ((double)j + 0.5) / 4.0;
                    double z = ((double)k + 0.5) / 4.0;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)loopPos.func_177958_n() + x, (double)loopPos.func_177956_o() + loopState.func_185900_c((IBlockAccess)this.field_145850_b, (BlockPos)loopPos).field_72337_e, (double)loopPos.func_177952_p() + z, ((double)this.func_174877_v().func_177958_n() - (double)loopPos.func_177958_n()) / 8.0, 0.0, ((double)this.func_174877_v().func_177952_p() - (double)loopPos.func_177952_p()) / 8.0, new int[]{Block.func_176210_f((IBlockState)loopState)});
                }
            }
        }
    }

    public IItemHandler getInventory() {
        return this.inv;
    }

    private void clearInv() {
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            this.inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    public int getEnchantingTicks() {
        return this.enchantingTicks;
    }

    public void advanceStage() {
        int mod = Math.floorMod(this.stage.ordinal() + 1, Stage.values().length);
        this.stage = Stage.values()[mod];
        this.enchantingTicks = 0;
        this.markBlockForUpdate();
        this.func_70296_d();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        tag.func_74768_a("UC_EnchantStage", this.stage.ordinal());
        if (this.enchanterId != null) {
            tag.func_74778_a("UC:targetEnchanter", this.enchanterId.toString());
        } else {
            tag.func_82580_o("UC:targetEnchanter");
        }
        tag.func_74768_a("UC_EnchantingTimer", this.enchantingTicks);
        tag.func_74768_a("UC_EnchantmentCost", this.enchantmentCost);
        if (!this.enchantItem.func_190926_b()) {
            tag.func_74782_a("enchItem", (NBTBase)this.enchantItem.serializeNBT());
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.inv.deserializeNBT(tag.func_74775_l("inventory"));
        this.stage = Stage.values()[tag.func_74762_e("UC_EnchantStage")];
        if (tag.func_74764_b("UC:targetEnchanter")) {
            this.enchanterId = UUID.fromString(tag.func_74779_i("UC:targetEnchanter"));
        }
        this.enchantingTicks = tag.func_74762_e("UC_EnchantingTimer");
        this.enchantmentCost = tag.func_74762_e("UC_EnchantmentCost");
        if (tag.func_74764_b("enchItem")) {
            this.enchantItem = new ItemStack((NBTTagCompound)tag.func_74781_a("enchItem"));
        }
    }

    public static enum Stage {
        IDLE,
        PREPARE{

            @Override
            public void advance(TileFascino tile) {
                if (tile.enchantingTicks >= 20) {
                    tile.advanceStage();
                }
            }
        }
        ,
        ENCHANT{

            @Override
            public void advance(TileFascino tile) {
                if (tile.enchantingTicks % 4 == 0) {
                    tile.loopEffects();
                }
                if (tile.enchantingTicks % 20 == 0) {
                    tile.advanceEnchanting();
                }
            }
        }
        ,
        STOP{

            @Override
            public void advance(TileFascino tile) {
                tile.enchanterId = null;
                tile.advanceStage();
            }
        };


        public void advance(TileFascino tile) {
        }
    }
}

