/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseRenderUC;
import com.bafomdad.uniquecrops.crops.supercrops.Itero;
import com.bafomdad.uniquecrops.network.PacketUCEffect;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileItero
extends TileBaseRenderUC
implements ITickable {
    boolean showDemo = false;
    int gameIndex = 0;
    int[] gameCombos;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 40L == 0L && this.showDemo && this.gameCombos != null && this.gameCombos.length > 0) {
            if (this.gameIndex >= this.gameCombos.length) {
                this.gameIndex = 0;
                this.showDemo = false;
                this.func_70296_d();
                UCPacketHandler.dispatchTEToNearbyPlayers(this);
                return;
            }
            BlockPos platePos = this.field_174879_c.func_177973_b((Vec3i)Itero.PLATES[this.gameCombos[this.gameIndex]]);
            IBlockState plate = this.field_145850_b.func_180495_p(platePos);
            if (plate.func_177230_c() == Blocks.field_150456_au) {
                this.field_145850_b.func_180501_a(platePos, plate.func_177226_a((IProperty)BlockPressurePlate.field_176580_a, (Comparable)Boolean.valueOf(true)), 3);
                this.field_145850_b.func_175684_a(platePos, plate.func_177230_c(), 20);
            }
            ++this.gameIndex;
        }
    }

    public int getDemoPlatePos() {
        if (!this.showingDemo() || this.gameCombos == null || this.gameCombos.length == 0) {
            return -1;
        }
        return this.gameCombos[this.gameIndex];
    }

    public boolean createCombos(int age) {
        if (this.gameCombos != null) {
            return false;
        }
        int rand = 4 + this.field_145850_b.field_73012_v.nextInt(age + 1);
        this.gameCombos = new int[rand];
        for (int i = 0; i < this.gameCombos.length; ++i) {
            this.gameCombos[i] = this.field_145850_b.field_73012_v.nextInt(Itero.PLATES.length);
        }
        return true;
    }

    public void matchCombo(BlockPos pos) {
        if (this.showDemo || this.gameCombos == null) {
            return;
        }
        BlockPos subPos = this.field_174879_c.func_177973_b((Vec3i)pos);
        if (this.gameIndex >= this.gameCombos.length) {
            this.reset();
            return;
        }
        if (Itero.PLATES[this.gameCombos[this.gameIndex]].equals((Object)subPos)) {
            if (++this.gameIndex >= this.gameCombos.length) {
                UCPacketHandler.sendToNearbyPlayers(this.field_145850_b, this.field_174879_c, new PacketUCEffect(EnumParticleTypes.END_ROD, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.3, this.field_174879_c.func_177952_p(), 4));
                this.advanceStage();
                this.reset();
                return;
            }
            UCPacketHandler.sendToNearbyPlayers(this.field_145850_b, this.field_174879_c, new PacketUCEffect(EnumParticleTypes.HEART, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.3, this.field_174879_c.func_177952_p(), 0));
            return;
        }
        UCPacketHandler.sendToNearbyPlayers(this.field_145850_b, this.field_174879_c, new PacketUCEffect(EnumParticleTypes.EXPLOSION_LARGE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.3, (double)this.field_174879_c.func_177952_p() + 0.5, 0));
        this.regressStage();
        this.reset();
    }

    public void tryShowDemo() {
        if (this.gameCombos != null && this.gameCombos.length > 0 && this.gameIndex == 0) {
            this.showDemo = true;
            UCPacketHandler.dispatchTEToNearbyPlayers(this);
        }
    }

    public void regressStage() {
        Itero itero = (Itero)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        int age = itero.getAge(this.field_145850_b.func_180495_p(this.field_174879_c));
        this.field_145850_b.func_175656_a(this.field_174879_c, itero.withAge(Math.max(--age, 0)));
    }

    public void advanceStage() {
        Itero itero = (Itero)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        this.field_145850_b.func_180501_a(this.field_174879_c, itero.withAge(itero.getAge(this.field_145850_b.func_180495_p(this.field_174879_c)) + 1), 3);
    }

    public void reset() {
        this.gameCombos = null;
        this.gameIndex = 0;
    }

    public boolean showingDemo() {
        return this.showDemo;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.showDemo = tag.func_74767_n("showDemo");
        this.gameIndex = tag.func_74762_e("gameIndex");
        if (this.gameCombos != null) {
            this.gameCombos = tag.func_74759_k("gameCombos");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74757_a("showDemo", this.showDemo);
        tag.func_74768_a("gameIndex", this.gameIndex);
        if (this.gameCombos != null) {
            tag.func_74783_a("gameCombos", this.gameCombos);
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        if (packet != null && packet.func_148857_g() != null) {
            this.readCustomNBT(packet.func_148857_g());
        }
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeCustomNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }
}

