/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.capabilities;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class CPCapability
implements INBTSerializable<NBTTagCompound> {
    int capacity = 100;
    int currentPower = 0;
    int cooldown = 0;
    boolean ignoreCooldown = false;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("UC:cropPowerCapacity", this.capacity);
        tag.func_74768_a("UC:cropPowerCurrent", this.currentPower);
        tag.func_74768_a("UC:cropPowerCooldown", this.cooldown);
        tag.func_74757_a("UC:ignoresCooldown", this.ignoreCooldown);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.capacity = nbt.func_74762_e("UC:cropPowerCapacity");
        this.currentPower = nbt.func_74762_e("UC:cropPowerCurrent");
        this.cooldown = nbt.func_74762_e("UC:cropPowerCooldown");
        this.ignoreCooldown = nbt.func_74767_n("UC:ignoresCooldown");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getPower() {
        return this.currentPower;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean hasCooldown() {
        if (this.ignoreCooldown) {
            return false;
        }
        return this.cooldown > 0;
    }

    public boolean canAdd() {
        return this.currentPower < this.capacity && !this.hasCooldown();
    }

    public void add(int add) {
        this.setPower(Math.min(this.currentPower + add, this.capacity));
        this.setCooldown(5);
    }

    public void remove(int subtract) {
        this.setPower(Math.max(this.currentPower - subtract, 0));
    }

    public void setPower(int power) {
        this.currentPower = power;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setCooldown(int amount) {
        this.cooldown = amount;
    }

    public void setIgnoreCooldown(boolean flag) {
        this.ignoreCooldown = flag;
    }
}

