/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();

    public static <T> T fromJson(@Nonnull TypeToken<T> token, @Nonnull File file, @Nonnull T def) {
        T ret = JsonUtils.fromJson(token, file);
        if (ret == null) {
            JsonUtils.toJson(def, token, file);
            ret = def;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T fromJson(@Nonnull TypeToken<T> token, @Nonnull File file) {
        Object object;
        if (!file.exists()) {
            return null;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            object = GSON.fromJson((Reader)reader, token.getType());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            return null;
        }
        IOUtils.closeQuietly((Reader)reader);
        return (T)object;
    }

    public static <T> T fromJson(@Nonnull TypeToken<T> token, @Nonnull String json) {
        return (T)GSON.fromJson(json, token.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void toJson(@Nonnull T type, @Nonnull TypeToken<T> token, @Nonnull File file) {
        if (!file.exists()) {
            try {
                FileUtils.forceMkdirParent((File)file);
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(JsonUtils.getJson(type, token));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public static <T> String getJson(@Nonnull T type, @Nonnull TypeToken<T> token) {
        return GSON.toJson(type, token.getType());
    }
}

