/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static boolean detectNBT(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static void initNBT(ItemStack stack) {
        if (!NBTUtils.detectNBT(stack)) {
            NBTUtils.injectNBT(stack, new NBTTagCompound());
        }
    }

    public static void injectNBT(ItemStack stack, NBTTagCompound nbt) {
        stack.func_77982_d(nbt);
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        NBTUtils.initNBT(stack);
        return stack.func_77978_p();
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        NBTUtils.getNBT(stack).func_74757_a(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        NBTUtils.getNBT(stack).func_74774_a(tag, b);
    }

    public static void setByteArray(ItemStack stack, String tag, byte[] b) {
        NBTUtils.getNBT(stack).func_74773_a(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        NBTUtils.getNBT(stack).func_74777_a(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        NBTUtils.getNBT(stack).func_74768_a(tag, i);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        NBTUtils.getNBT(stack).func_74772_a(tag, l);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        NBTUtils.getNBT(stack).func_74776_a(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        NBTUtils.getNBT(stack).func_74780_a(tag, d);
    }

    public static void setCompound(ItemStack stack, String tag, NBTTagCompound cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            NBTUtils.getNBT(stack).func_74782_a(tag, (NBTBase)cmp);
        }
    }

    public static void setString(ItemStack stack, String tag, String s) {
        NBTUtils.getNBT(stack).func_74778_a(tag, s);
    }

    public static void setList(ItemStack stack, String tag, NBTTagList list) {
        NBTUtils.getNBT(stack).func_74782_a(tag, (NBTBase)list);
    }

    public static void setIntArray(ItemStack stack, String key, int[] val) {
        NBTUtils.getCompound(stack, key, true).func_74783_a(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return NBTUtils.detectNBT(stack) ? NBTUtils.getCompound(stack, key, true).func_74759_k(key) : new int[]{};
    }

    public static boolean verifyExistance(ItemStack stack, String tag) {
        return stack != null && NBTUtils.getNBT(stack).func_74764_b(tag);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74767_n(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74771_c(tag) : defaultExpected;
    }

    public static byte[] getByteArray(ItemStack stack, String tag) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74770_j(tag) : null;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74765_d(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74762_e(tag) : defaultExpected;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74763_f(tag) : defaultExpected;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74760_g(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74769_h(tag) : defaultExpected;
    }

    public static NBTTagCompound getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74775_l(tag) : (nullifyOnFail ? null : new NBTTagCompound());
    }

    public static String getString(ItemStack stack, String tag, String defaultExpected) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_74779_i(tag) : defaultExpected;
    }

    public static NBTTagList getList(ItemStack stack, String tag, int objtype, boolean nullifyOnFail) {
        return NBTUtils.verifyExistance(stack, tag) ? NBTUtils.getNBT(stack).func_150295_c(tag, objtype) : (nullifyOnFail ? null : new NBTTagList());
    }
}

