/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core;

import com.bafomdad.uniquecrops.core.JsonUtils;
import com.bafomdad.uniquecrops.core.MultiblockPattern;
import com.bafomdad.uniquecrops.core.UCStrings;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.FileUtils;

@Config.LangKey(value="uniquecrops.general")
@Config(modid="uniquecrops")
public class UCConfig {
    @Config.Comment(value={"Drop weight for the mod's starting seed. The higher the number, the more often it'll drop."})
    public static int dropRate = 5;
    @Config.Comment(value={"Time (in minutes) it takes for Millennium crop to advance a stage."})
    public static int millenniumTime = 10;
    @Config.Comment(value={"Lets the Petramia crop convert obsidian instead of bedrock. Use if there are no bedrock nearby to convert."})
    public static boolean convertObsidian = false;
    @Config.Comment(value={"Skeleton spawners placed in the nether has a chance of spawning wither skeletons instead."})
    public static boolean witherSkeletonSpawner = false;
    @Config.Comment(value={"Adjust placement of Wildwood staff GUI on the x axis."})
    public static int guiWidth = -191;
    @Config.Comment(value={"Adjust placement of Wildwood staff GUI on the y axis."})
    public static int guiHeight = -50;
    @Config.Comment(value={"Cooldown time (in ticks) for rubik's cube between successful teleports."})
    public static int cubeCooldown = 3600;
    @Config.Comment(value={"Amount of energy gained per tick while the Industria crop grows."})
    public static int energyPerTick = 20;
    @Config.Comment(value={"Max capacity of the battery beans that will be dropped."})
    public static int beanBatteryCapacity = 500;
    @Config.Comment(value={"Set to false to disable generation of ruins, full stop."})
    public static boolean ruinsGeneration = true;
    @Config.Comment(value={"Weight chance for underground ruins to generate in overworld. The lower the number, the higher the chance."})
    @Config.RangeInt(min=6, max=600)
    public static int worldGenerationRuinsWeight = 40;
    @Config.Comment(value={"List of items that will be randomly dropped by the Normie crop on harvest. Items only, no damage values."})
    public static String[] randomDrops = new String[]{"minecraft:wheat", "minecraft:carrot", "minecraft:potato", "minecraft:beetroot", "minecraft:melon"};
    private static File multiblockDirectory;
    private static List<MultiblockPattern> multiblockPatterns;

    public static void init(FMLPreInitializationEvent event) {
        multiblockDirectory = new File(event.getModConfigurationDirectory().getParentFile(), File.separator + "uniquecrops");
    }

    public static void syncMultiblocks() {
        multiblockPatterns.clear();
        if (UCConfig.getDirectoryListing() != null) {
            for (File file : UCConfig.getDirectoryListing()) {
                MultiblockPattern pattern = (MultiblockPattern)JsonUtils.fromJson(TypeToken.get(MultiblockPattern.class), file);
                if (pattern == null) continue;
                multiblockPatterns.add(pattern);
            }
        }
    }

    public static List<MultiblockPattern> getPatterns() {
        return multiblockPatterns;
    }

    private static List<File> getDirectoryListing() {
        ArrayList<File> files;
        if (multiblockDirectory == null) {
            return null;
        }
        if (!multiblockDirectory.exists()) {
            UCConfig.fillDirectory();
        }
        if (!(files = new ArrayList<File>(Arrays.asList(multiblockDirectory.listFiles()))).isEmpty()) {
            return files;
        }
        return null;
    }

    private static void fillDirectory() {
        try {
            for (String fileName : UCStrings.DEFAULT_MULTIBLOCKS) {
                InputStream fis = UCConfig.class.getClassLoader().getResourceAsStream("assets/uniquecrops/multiblocks/" + fileName);
                FileUtils.copyToFile((InputStream)fis, (File)new File(multiblockDirectory, fileName));
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        multiblockPatterns = new ArrayList<MultiblockPattern>();
    }

    @Config.LangKey(value="uniquecrops.conditions")
    @Config(modid="uniquecrops", category="conditions")
    public static class GrowthConfig {
        public static boolean moonPhase = true;
        public static boolean hasTorch = true;
        public static boolean likesDarkness = true;
        public static boolean dryFarmland = true;
        public static boolean underFarmland = true;
        public static boolean burningPlayer = true;
        public static boolean hellWorld = true;
        public static boolean likesHeights = true;
        public static boolean likesLilypads = true;
        public static boolean thirstyPlant = true;
        public static boolean hungryPlant = true;
        public static boolean likesChicken = true;
        public static boolean likesRedstone = true;
        public static boolean vampirePlant = true;
        public static boolean fullBrightness = true;
        public static boolean likesWarts = true;
        public static boolean likesCooking = true;
        public static boolean likesBrewing = true;
        public static boolean likesCheckers = true;
        public static boolean dontBonemeal = true;
        public static boolean selfSacrifice = true;
    }

    @Config.LangKey(value="uniquecrops.crops")
    @Config(modid="uniquecrops", category="crops")
    public static class CropConfig {
        @Config.Comment(value={"Can plant Normie seeds"})
        public static boolean cropNormal = true;
        @Config.Comment(value={"Can plant Precision seeds"})
        public static boolean cropPrecision = true;
        @Config.Comment(value={"Can plant Dirigible plums"})
        public static boolean cropDirigible = true;
        @Config.Comment(value={"Can plant Weeping Bells"})
        public static boolean cropWeepingbells = true;
        @Config.Comment(value={"Can plant Knowledge seeds"})
        public static boolean cropKnowledge = true;
        @Config.Comment(value={"Can plant Ender lily seeds"})
        public static boolean cropEnderlily = true;
        @Config.Comment(value={"Can plant Millennium seeds"})
        public static boolean cropMillennium = true;
        @Config.Comment(value={"Can plant Merlinia seeds"})
        public static boolean cropMerlinia = true;
        @Config.Comment(value={"Can plant Invisibilia seeds"})
        public static boolean cropInvisibilia = true;
        @Config.Comment(value={"Can plant Musica seeds"})
        public static boolean cropMusica = true;
        @Config.Comment(value={"Can plant Feroxia seeds"})
        public static boolean cropFeroxia = true;
        @Config.Comment(value={"Can plant Cinderbella shoots"})
        public static boolean cropCinderbella = true;
        @Config.Comment(value={"Can plant Goldenrod seeds"})
        public static boolean cropCollis = true;
        @Config.Comment(value={"Can plant Mary-jane seeds"})
        public static boolean cropMaryjane = true;
        @Config.Comment(value={"Can plant EULA seeds"})
        public static boolean cropEula = true;
        @Config.Comment(value={"Can plant Dyeius seeds"})
        public static boolean cropDyeius = true;
        @Config.Comment(value={"Can plant Cobblonia seeds"})
        public static boolean cropCobblonia = true;
        @Config.Comment(value={"Can plant Abstract seeds"})
        public static boolean cropAbstract = true;
        @Config.Comment(value={"Can plant Wafflonia seeds"})
        public static boolean cropWafflonia = true;
        @Config.Comment(value={"Can plant Devil's Snares"})
        public static boolean cropDevilsnare = true;
        @Config.Comment(value={"Can plant Pixelsius seeds"})
        public static boolean cropPixelsius = true;
        @Config.Comment(value={"Can plant Artisia seeds"})
        public static boolean cropArtisia = true;
        @Config.Comment(value={"Can plant Malleatoris seeds"})
        public static boolean cropMalleatoris = true;
        @Config.Comment(value={"Can plant Petramia seeds"})
        public static boolean cropPetramia = true;
        @Config.Comment(value={"Can plant Imperia seeds"})
        public static boolean cropImperia = true;
        @Config.Comment(value={"Can plant Lacusia seeds"})
        public static boolean cropLacusia = true;
        @Config.Comment(value={"Can plant Hexis seeds"})
        public static boolean cropHexis = true;
        @Config.Comment(value={"Can plant Industria seeds"})
        public static boolean cropIndustria = true;
        @Config.Comment(value={"Can plant Quarry seeds"})
        public static boolean cropQuarry = true;
        @Config.Comment(value={"Can plant Donut seeds"})
        public static boolean cropDonutSteel = true;
        @Config.Comment(value={"Can plant Instabilis seeds"})
        public static boolean cropInstabilis = true;
        @Config.Comment(value={"Can plant Succo seeds"})
        public static boolean cropVampire = true;
        @Config.Comment(value={"Can plant Holiday Jellybeans"})
        public static boolean cropAdventus;
        @Config.Comment(value={"Can plant Blessed Seeds"})
        public static boolean cropHoly;
        @Config.Comment(value={"Can plant Magnet Seeds"})
        public static boolean cropMagnets;

        static {
            cropHoly = true;
            cropMagnets = true;
        }
    }
}

