/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core;

import com.bafomdad.uniquecrops.core.enums.EnumGrowthSteps;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.network.PacketBiomeChange;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class UCUtils {
    public static EntityPlayer getPlayerFromUsername(String username) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return null;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(username);
    }

    public static EntityPlayer getPlayerFromUUID(String uuid) {
        return UCUtils.getPlayerFromUsername(UCUtils.getUsernameFromUUID(uuid));
    }

    public static String getUsernameFromUUID(String uuid) {
        return UsernameCache.getLastKnownUsername((UUID)UUID.fromString(uuid));
    }

    public static EntityLivingBase getTaggedEntity(UUID uuid) {
        if (uuid != null) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            for (WorldServer wServer : server.field_71305_c) {
                for (Object obj : wServer.field_72996_f) {
                    EntityLivingBase living;
                    UUID id;
                    if (!(obj instanceof EntityLivingBase) || !uuid.equals(id = (living = (EntityLivingBase)obj).getPersistentID()) || !living.func_70089_S()) continue;
                    return living;
                }
            }
        }
        return null;
    }

    public static EntityLivingBase getTaggedEntity(World world, BlockPos pos, UUID uuid, int range) {
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos.func_177982_a(-range, 0, -range), pos.func_177982_a(range, 2, range)));
        if (entities.isEmpty()) {
            return null;
        }
        for (Entity ent : entities) {
            EntityLivingBase elb;
            UUID id;
            if (!(ent instanceof EntityLivingBase) || !uuid.equals(id = (elb = (EntityLivingBase)ent).getPersistentID()) || !elb.func_70089_S()) continue;
            return elb;
        }
        return null;
    }

    public static NBTTagList getServerTaglist(UUID uuid) {
        NBTTagCompound tag;
        MinecraftServer ms = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (ms == null) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)ms.func_175576_a(uuid);
        if (player != null && (tag = player.getEntityData()).func_74764_b("UC_FeroxiaGrowth")) {
            return tag.func_150295_c("UC_FeroxiaGrowth", 10);
        }
        return null;
    }

    public static void updateBook(EntityPlayer player) {
        if (!player.field_71071_by.func_70431_c(EnumItems.GUIDE.createStack())) {
            return;
        }
        NBTTagList taglist = UCUtils.getServerTaglist(player.func_110124_au());
        if (taglist != null) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack book = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (book.func_190926_b() || book.func_77973_b() != UCItems.generic || book.func_77952_i() != EnumItems.GUIDE.ordinal()) continue;
                if (book.func_77942_o() && book.func_77978_p().func_74764_b("UC_FeroxiaGrowth")) {
                    book.func_77978_p().func_82580_o("UC_FeroxiaGrowth");
                }
                book.func_77983_a("UC_FeroxiaGrowth", (NBTBase)taglist);
            }
        }
    }

    public static TileEntity getClosestTile(Class tileToFind, World world, BlockPos pos, double dist) {
        TileEntity closest = null;
        for (TileEntity tile : world.field_147482_g) {
            if (tile.getClass() != tileToFind || pos.equals((Object)tile.func_174877_v())) continue;
            double distance = tile.func_174877_v().func_177951_i((Vec3i)pos);
            if (closest != null || !(distance <= dist)) continue;
            closest = tile;
            break;
        }
        return closest;
    }

    public static void generateSteps(EntityPlayer player) {
        NBTTagCompound tag = player.getEntityData();
        if (player.func_130014_f_().field_73012_v.nextInt(200) == 0) {
            if (tag.func_74764_b("UC_FeroxiaGrowth")) {
                tag.func_82580_o("UC_FeroxiaGrowth");
            }
            NBTTagList taglist = new NBTTagList();
            NBTTagCompound tag2 = new NBTTagCompound();
            tag2.func_74768_a("stage0", 20);
            taglist.func_74742_a((NBTBase)tag2);
            tag.func_74782_a("UC_FeroxiaGrowth", (NBTBase)taglist);
            return;
        }
        ArrayList copysteps = new ArrayList();
        Arrays.stream(EnumGrowthSteps.values()).forEach(g -> {
            if (g.isEnabled() && g.ordinal() != EnumGrowthSteps.SELFSACRIFICE.ordinal()) {
                copysteps.add(g);
            }
        });
        Collections.shuffle(copysteps);
        NBTTagList taglist = new NBTTagList();
        for (int i = 0; i < 7; ++i) {
            NBTTagCompound tag2 = new NBTTagCompound();
            int index = ((EnumGrowthSteps)((Object)copysteps.get(0))).ordinal();
            copysteps.remove(0);
            tag2.func_74768_a("stage" + i, index);
            taglist.func_74742_a((NBTBase)tag2);
        }
        tag.func_74782_a("UC_FeroxiaGrowth", (NBTBase)taglist);
    }

    public static boolean setBiome(int biomeId, World world, BlockPos pos) {
        Biome biome = Biome.func_150568_d((int)biomeId);
        if (biome != null) {
            if (biome == world.func_180494_b(pos)) {
                return false;
            }
            byte[] biomeArray = world.func_175726_f(pos).func_76605_m();
            int i = pos.func_177958_n() & 0xF;
            int j = pos.func_177952_p() & 0xF;
            biomeArray[j << 4 | i] = (byte)biomeId;
            world.func_175726_f(pos).func_76616_a(biomeArray);
            world.func_175726_f(pos).func_76630_e();
            world.func_175704_b(pos, pos);
            if (!world.field_72995_K) {
                UCPacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketBiomeChange(i, pos.func_177956_o(), j, (short)biomeId), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)i, (double)pos.func_177956_o(), (double)j, 32.0));
            }
        }
        return true;
    }

    public static <E> List<E> makeCollection(Iterable<E> iter, boolean shuffle) {
        ArrayList list = new ArrayList();
        iter.forEach(list::add);
        if (shuffle) {
            Collections.shuffle(list);
        }
        return list;
    }

    public static <T> T selectRandom(Random rand, T ... type) {
        return type[rand.nextInt(type.length)];
    }
}

