/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core.enums;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;

public enum EnumDirectional implements IStringSerializable
{
    NORTH(0, 1, "north"),
    SOUTH(1, 0, "south"),
    EAST(2, 3, "east"),
    WEST(3, 2, "west"),
    NORTHEAST(4, 7, "northeast"),
    NORTHWEST(5, 6, "northwest"),
    SOUTHEAST(6, 5, "southeast"),
    SOUTHWEST(7, 4, "southwest"),
    UP(8, 9, "up"),
    DOWN(9, 8, "down");

    private final String name;
    private final int index;
    private final int opposite;

    private EnumDirectional(int index, int opposite, String name) {
        this.name = name;
        this.index = index;
        this.opposite = opposite;
    }

    public BlockPos getOffset(BlockPos pos) {
        switch (this) {
            case NORTH: {
                return pos.func_177978_c();
            }
            case SOUTH: {
                return pos.func_177968_d();
            }
            case EAST: {
                return pos.func_177974_f();
            }
            case WEST: {
                return pos.func_177976_e();
            }
            case NORTHEAST: {
                return pos.func_177978_c().func_177974_f();
            }
            case NORTHWEST: {
                return pos.func_177978_c().func_177976_e();
            }
            case SOUTHEAST: {
                return pos.func_177968_d().func_177974_f();
            }
            case SOUTHWEST: {
                return pos.func_177968_d().func_177976_e();
            }
        }
        return pos;
    }

    public EnumDirectional getOpposite() {
        return EnumDirectional.byIndex(this.opposite);
    }

    public static EnumDirectional byIndex(int meta) {
        return EnumDirectional.values()[meta];
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }
}

