/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class EnchantmentRecipe {
    Enchantment enchantment;
    int cost;
    List<Ingredient> inputs;

    public EnchantmentRecipe(Enchantment enchantment, int cost, Ingredient[] inputs) {
        if (enchantment == null) {
            throw new IllegalStateException("Enchantment cannot be null");
        }
        if (cost < 0) {
            cost = 0;
        }
        if (inputs == null || inputs.length <= 0) {
            throw new IllegalStateException("Inputs cannot be empty or null");
        }
        this.enchantment = enchantment;
        this.cost = cost;
        this.inputs = new ArrayList<Ingredient>();
        this.inputs.addAll(Arrays.asList(inputs));
    }

    public EnchantmentRecipe(String enchantmentLocation, int cost, Ingredient[] inputs) {
        if (enchantmentLocation == null || enchantmentLocation.isEmpty()) {
            throw new IllegalStateException("Enchantment id cannot be empty or null");
        }
        if (cost < 0) {
            cost = 0;
        }
        if (inputs == null || inputs.length <= 0) {
            throw new IllegalStateException("Inputs cannot be empty or null");
        }
        if (inputs.length > 5) {
            throw new IllegalStateException("Inputs cannot exceed 5 items");
        }
        this.enchantment = Enchantment.func_180305_b((String)enchantmentLocation);
        this.cost = cost;
        this.inputs = new ArrayList<Ingredient>();
        this.inputs.addAll(Arrays.asList(inputs));
    }

    public boolean matches(List<ItemStack> stackList) {
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>(this.inputs);
        for (ItemStack stack : stackList) {
            if (stack.func_190926_b()) break;
            int stackIndex = -1;
            for (int j = 0; j < inputsMissing.size(); ++j) {
                Ingredient input = (Ingredient)inputsMissing.get(j);
                if (!input.apply(stack)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex >= 0) {
                inputsMissing.remove(stackIndex);
                continue;
            }
            return false;
        }
        return inputsMissing.isEmpty();
    }

    public boolean matchesEnchantment(String location) {
        return this.enchantment.getRegistryName().toString().equals(location);
    }

    public void applyEnchantment(ItemStack toApply) {
        toApply.func_77966_a(this.enchantment, this.enchantment.func_77325_b());
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public List<Ingredient> getInputs() {
        return new ArrayList<Ingredient>(this.inputs);
    }

    public int getCost() {
        return this.cost;
    }
}

