/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crops;

import com.bafomdad.uniquecrops.blocks.BlockCropsBase;
import com.bafomdad.uniquecrops.blocks.tiles.TileFeroxia;
import com.bafomdad.uniquecrops.core.UCUtils;
import com.bafomdad.uniquecrops.core.enums.EnumCrops;
import com.bafomdad.uniquecrops.core.enums.EnumGrowthSteps;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Feroxia
extends BlockCropsBase {
    public Feroxia() {
        super(EnumCrops.SAVAGEPLANT);
        GameRegistry.registerTileEntity(TileFeroxia.class, (ResourceLocation)new ResourceLocation("uniquecrops", "feroxia"));
    }

    public Item func_149866_i() {
        return UCItems.seedsFeroxia;
    }

    public Item func_149865_P() {
        return UCItems.generic;
    }

    @Override
    public boolean canPlantCrop(World world, EntityPlayer player, EnumFacing side, BlockPos pos, ItemStack stack) {
        this.func_180633_a(world, pos.func_177972_a(side), this.func_176223_P(), (EntityLivingBase)player, stack);
        return super.canPlantCrop(world, player, side, pos, stack);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            return 0;
        }
        return random.nextInt(4) + 2;
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            return 1;
        }
        return 9;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_185527_x(state) >= this.func_185526_g()) {
            return;
        }
        if (this.canIgnoreGrowthRestrictions(world, pos)) {
            super.func_180650_b(world, pos, state, rand);
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (!this.func_180671_f(world, pos, state)) {
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, new ItemStack(this.func_149866_i()));
            world.func_72838_d((Entity)ei);
            world.func_175698_g(pos);
            return;
        }
        int stage = this.getStage(world, pos, state);
        if (stage == -1) {
            return;
        }
        if (!EnumGrowthSteps.values()[stage].canAdvance(world, pos, state)) {
            return;
        }
        if (rand.nextInt(3) == 0) {
            world.func_180501_a(pos, this.func_185528_e(this.func_185527_x(state) + 1), 3);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state, 2);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileFeroxia) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            if (placer instanceof EntityPlayer && !(placer instanceof FakePlayer) && !world.field_72995_K) {
                ((TileFeroxia)te).setOwner(placer.func_110124_au());
                if (!placer.getEntityData().func_74764_b("UC_FeroxiaGrowth")) {
                    UCUtils.generateSteps((EntityPlayer)placer);
                }
                UCUtils.updateBook((EntityPlayer)placer);
            }
        }
    }

    @Override
    public void func_176487_g(World world, BlockPos pos, IBlockState state) {
        if (this.func_185527_x(state) >= this.func_185526_g() || world.field_72995_K) {
            return;
        }
        int stage = this.getStage(world, pos, state);
        if (stage != -1 && EnumGrowthSteps.values()[stage].ordinal() == EnumGrowthSteps.NOBONEMEAL.ordinal()) {
            world.func_180501_a(pos, this.func_185528_e(0), 3);
            return;
        }
        if (stage != -1 && EnumGrowthSteps.values()[stage].canAdvance(world, pos, state)) {
            world.func_180501_a(pos, this.func_185528_e(this.func_185527_x(state) + 1), 3);
            return;
        }
    }

    private int getStage(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileFeroxia)) {
            return -1;
        }
        TileFeroxia te = (TileFeroxia)tile;
        if (te.getOwner() == null || te.getOwner() != null && UCUtils.getPlayerFromUUID(te.getOwner().toString()) == null) {
            return -1;
        }
        NBTTagList taglist = UCUtils.getServerTaglist(te.getOwner());
        if (taglist == null) {
            return -1;
        }
        NBTTagCompound tag = taglist.func_150305_b(this.func_185527_x(state));
        return tag.func_74762_e("stage" + this.func_185527_x(state));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFeroxia();
    }
}

