/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crops;

import com.bafomdad.uniquecrops.blocks.BlockCropsBase;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.enums.EnumCrops;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Knowledge
extends BlockCropsBase {
    Pattern pat = Pattern.compile("[aeiou]", 34);
    private static final String BOOKMARK = "UC:tagBookmark";

    public Knowledge() {
        super(EnumCrops.BOOKPLANT);
    }

    public Item func_149866_i() {
        return UCItems.seedsKnowledge;
    }

    public Item func_149865_P() {
        return UCItems.generic;
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            return 0;
        }
        return 1;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.canIgnoreGrowthRestrictions(world, pos)) {
            super.func_180650_b(world, pos, state, rand);
            return;
        }
        this.func_176475_e(world, pos, state);
        if (this.func_185527_x(state) >= this.func_185526_g() || world.field_72995_K) {
            return;
        }
        int growStages = this.consumeKnowledge(world, pos);
        if (growStages > 0) {
            world.func_180501_a(pos, this.func_185528_e(Math.min(this.func_185527_x(state) + growStages, this.func_185526_g())), 2);
        }
    }

    private int consumeKnowledge(World world, BlockPos pos) {
        Iterable getBox = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -2, -4), (BlockPos)pos.func_177982_a(4, 2, 4));
        for (BlockPos posit : getBox) {
            TileEntity te;
            Block loopblock = world.func_180495_p(posit).func_177230_c();
            if (!(loopblock.getEnchantPowerBonus(world, posit) >= 1.0f) || (te = world.func_175625_s(posit.func_177984_a())) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) continue;
            IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            for (int i = 0; i < cap.getSlots(); ++i) {
                NBTTagCompound tag;
                ItemStack book = cap.getStackInSlot(i);
                if (book.func_190926_b() || book.func_77973_b() != Items.field_151164_bB || !ItemWrittenBook.func_77828_a((NBTTagCompound)(tag = book.func_77978_p())) || NBTUtils.getBoolean(book, BOOKMARK, false) || ItemWrittenBook.func_179230_h((ItemStack)book) != 0) continue;
                int result = 0;
                NBTTagList tagList = tag.func_150295_c("pages", 8);
                for (int j = 0; j < tagList.func_74745_c(); ++j) {
                    ITextComponent text;
                    String str = tagList.func_150307_f(j);
                    try {
                        text = ITextComponent.Serializer.func_186877_b((String)str);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        text = new TextComponentString(str);
                    }
                    String newString = this.eatSomeVowels(text.func_150260_c());
                    TextComponentString newComponent = new TextComponentString(newString);
                    tagList.func_150304_a(j, (NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)newComponent)));
                    result = j + 1;
                }
                tag.func_74782_a("pages", (NBTBase)tagList);
                NBTUtils.setBoolean(book, BOOKMARK, true);
                return result;
            }
        }
        return 0;
    }

    private String eatSomeVowels(String str) {
        StringBuilder sb = new StringBuilder(str);
        if (str.length() >= 100 && str.length() <= 512) {
            sb.replace(0, str.length(), str.replaceAll(this.pat.pattern(), " "));
            return sb.toString();
        }
        return str;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.func_185527_x(state) >= this.func_185526_g()) {
            double x = pos.func_177958_n();
            double y = (double)pos.func_177956_o() + 0.5;
            double z = pos.func_177952_p();
            world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x + (double)rand.nextFloat(), y, z + (double)rand.nextFloat(), rand.nextGaussian(), (double)rand.nextFloat(), rand.nextGaussian(), new int[0]);
        }
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.func_185527_x(world.func_180495_p(pos)) >= this.func_185526_g() ? 3.0f : 0.0f;
    }
}

