/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crops;

import com.bafomdad.uniquecrops.blocks.BlockCropsBase;
import com.bafomdad.uniquecrops.core.enums.EnumCrops;
import com.bafomdad.uniquecrops.entities.EntityMovingCrop;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Magnes
extends BlockCropsBase {
    public static PropertyBool POLARITY = PropertyBool.func_177716_a((String)"polarity");
    private static final int RANGE = 7;

    public Magnes() {
        super(EnumCrops.MAGNETS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)POLARITY, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176488_a, POLARITY});
    }

    public boolean isBlue(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POLARITY);
    }

    public boolean isOpposite(IBlockState state1, IBlockState state2) {
        return state1.func_177229_b((IProperty)POLARITY) != state2.func_177229_b((IProperty)POLARITY);
    }

    public Item func_149866_i() {
        return UCItems.seedsMagnets;
    }

    public Item func_149865_P() {
        return Items.field_190931_a;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(meta & 7)).func_177226_a((IProperty)POLARITY, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)field_176488_a);
        if (this.isBlue(state)) {
            i |= 8;
        }
        return i;
    }

    public int func_185527_x(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_176488_a);
    }

    public boolean func_185525_y(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e()) >= this.func_185526_g();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.func_185525_y(state)) {
            int[] oreIDs;
            for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (OreDictionary.getOreName((int)id).equals("dyeBlue")) {
                    if (this.isBlue(state)) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    world.func_180501_a(pos, state.func_177226_a((IProperty)POLARITY, (Comparable)Boolean.valueOf(true)), 2);
                    return true;
                }
                if (!OreDictionary.getOreName((int)id).equals("dyeRed") || !this.isBlue(state)) continue;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                world.func_180501_a(pos, state.func_177226_a((IProperty)POLARITY, (Comparable)Boolean.valueOf(false)), 2);
                return true;
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (this.func_185525_y(state)) {
            this.magnetize(world, pos, state);
        }
    }

    private void magnetize(World world, BlockPos pos, IBlockState state) {
        block0: for (EnumFacing facing : EnumFacing.field_176754_o) {
            for (int i = 0; i < 7; ++i) {
                BlockPos loopPos = pos.func_177967_a(facing, i);
                IBlockState loopState = world.func_180495_p(loopPos);
                if (loopState.func_185904_a() == Material.field_151579_a) continue;
                if (loopState.func_177230_c() == this && this.isOpposite(state, loopState) && this.func_185525_y(loopState) && i > 1) {
                    this.spawnMovingCrop(world, pos, state, facing, i);
                    this.spawnMovingCrop(world, loopPos, loopState, facing.func_176734_d(), i);
                    continue block0;
                }
                if (loopState.func_177230_c() != this) continue block0;
            }
        }
    }

    private void spawnMovingCrop(World world, BlockPos pos, IBlockState state, EnumFacing facing, int distance) {
        IBlockState savedState = state;
        EntityFallingBlock fallingBlock = new EntityFallingBlock(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), savedState);
        fallingBlock.func_189654_d(true);
        fallingBlock.field_145812_b = 10;
        fallingBlock.field_70143_R = 10.0f;
        EntityMovingCrop entity = new EntityMovingCrop(world, pos, facing, distance);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
            world.func_72838_d((Entity)entity);
            world.func_72838_d((Entity)fallingBlock);
            fallingBlock.func_184220_m((Entity)entity);
        }
    }
}

