/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crops.supercrops;

import com.bafomdad.uniquecrops.blocks.BlockSuperCropsBase;
import com.bafomdad.uniquecrops.blocks.tiles.TileWeatherflesia;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.enums.EnumDirectional;
import com.bafomdad.uniquecrops.core.enums.EnumSuperCrops;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Weatherflesia
extends BlockSuperCropsBase {
    private static final String[] BIOME_NAME = new String[]{"biomeName", "field_76791_y"};
    public static final PropertyEnum RAFFLESIA = PropertyEnum.func_177709_a((String)"rafflesia", EnumDirectional.class);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 0.5), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.625, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.625, 1.0), new AxisAlignedBB(1.0, 0.0, 1.0, 0.5, 0.625, 0.5), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.625, 0.5), new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.625, 0.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)};

    public Weatherflesia() {
        super(EnumSuperCrops.WEATHER);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RAFFLESIA, (Comparable)((Object)EnumDirectional.UP)));
        GameRegistry.registerTileEntity(TileWeatherflesia.class, (ResourceLocation)new ResourceLocation("uniquecrops", "TileWeatherflesia"));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{RAFFLESIA});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[this.func_176201_c(state)];
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileWeatherflesia) {
            TileWeatherflesia weather = (TileWeatherflesia)tile;
            weather.tickBiomeStrength();
            ItemStack stack = weather.getItem();
            if (!stack.func_190926_b() && stack.func_77951_h()) {
                int repairStrength = weather.getBiomeStrength() / 2;
                stack.func_77964_b(stack.func_77952_i() - repairStrength);
                weather.markBlockForUpdate();
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        BlockPos offset = pos;
        int stateMeta = this.func_176201_c(state);
        if (stateMeta != EnumDirectional.UP.ordinal() || stateMeta != EnumDirectional.DOWN.ordinal()) {
            offset = this.offsetDirectional(state, pos);
        }
        if ((tile = world.func_175625_s(offset)) instanceof TileWeatherflesia) {
            TileWeatherflesia weather = (TileWeatherflesia)tile;
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b() && stack.func_77973_b() == UCItems.pixelBrush && !player.func_70093_af()) {
                int biomeId = Biome.func_185362_a((Biome)world.func_180494_b(offset));
                NBTUtils.setInt(stack, "UC_tagSavedBiome", biomeId);
                weather.setItem(stack);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                weather.markBlockForUpdate();
                return true;
            }
            if (stack.func_190926_b() && player.func_70093_af()) {
                ItemStack tileItem = weather.getItem();
                if (!tileItem.func_190926_b()) {
                    weather.setItem(ItemStack.field_190927_a);
                    player.func_184611_a(hand, tileItem);
                    weather.markBlockForUpdate();
                }
                return true;
            }
        }
        return false;
    }

    private BlockPos offsetDirectional(IBlockState state, BlockPos pos) {
        BlockPos offPos = pos;
        EnumDirectional dir = ((EnumDirectional)((Object)state.func_177229_b((IProperty)RAFFLESIA))).getOpposite();
        switch (dir) {
            case NORTH: {
                offPos = offPos.func_177972_a(EnumFacing.NORTH);
                break;
            }
            case SOUTH: {
                offPos = offPos.func_177972_a(EnumFacing.SOUTH);
                break;
            }
            case EAST: {
                offPos = offPos.func_177972_a(EnumFacing.EAST);
                break;
            }
            case WEST: {
                offPos = offPos.func_177972_a(EnumFacing.WEST);
                break;
            }
            case NORTHWEST: {
                offPos = offPos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.WEST);
                break;
            }
            case NORTHEAST: {
                offPos = offPos.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST);
                break;
            }
            case SOUTHWEST: {
                offPos = offPos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.WEST);
                break;
            }
            case SOUTHEAST: {
                offPos = offPos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST);
                break;
            }
        }
        return offPos;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.func_176475_e(world, pos, state);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (this.func_176201_c(state) == EnumDirectional.DOWN.ordinal() || this.func_176201_c(state) == EnumDirectional.UP.ordinal()) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos loopPos = pos.func_177972_a(facing);
                if (!world.func_175623_d(loopPos)) continue;
                world.func_175655_b(pos, false);
                return;
            }
        }
        if (this.isNeighborMissing(world, pos, state)) {
            world.func_175655_b(pos, false);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileWeatherflesia weather;
        ItemStack stack;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileWeatherflesia && !(stack = (weather = (TileWeatherflesia)tile).getItem()).func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
        super.func_180663_b(world, pos, state);
    }

    private boolean isNeighborMissing(World world, BlockPos pos, IBlockState state) {
        if (!(state.func_177230_c() instanceof Weatherflesia)) {
            return false;
        }
        EnumDirectional prop = (EnumDirectional)((Object)state.func_177229_b((IProperty)RAFFLESIA));
        switch (prop) {
            case NORTH: {
                return this.isRafflesia(world, pos.func_177974_f()) || this.isRafflesia(world, pos.func_177976_e());
            }
            case SOUTH: {
                return this.isRafflesia(world, pos.func_177974_f()) || this.isRafflesia(world, pos.func_177976_e());
            }
            case WEST: {
                return this.isRafflesia(world, pos.func_177978_c()) || this.isRafflesia(world, pos.func_177968_d());
            }
            case EAST: {
                return this.isRafflesia(world, pos.func_177978_c()) || this.isRafflesia(world, pos.func_177968_d());
            }
            case NORTHEAST: {
                return this.isRafflesia(world, pos.func_177968_d()) || this.isRafflesia(world, pos.func_177976_e());
            }
            case NORTHWEST: {
                return this.isRafflesia(world, pos.func_177968_d()) || this.isRafflesia(world, pos.func_177974_f());
            }
            case SOUTHEAST: {
                return this.isRafflesia(world, pos.func_177978_c()) || this.isRafflesia(world, pos.func_177976_e());
            }
            case SOUTHWEST: {
                return this.isRafflesia(world, pos.func_177978_c()) || this.isRafflesia(world, pos.func_177974_f());
            }
        }
        return false;
    }

    private boolean isRafflesia(World world, BlockPos pos) {
        return !(world.func_180495_p(pos).func_177230_c() instanceof Weatherflesia);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)RAFFLESIA, (Comparable)((Object)EnumDirectional.byIndex(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDirectional)((Object)state.func_177229_b((IProperty)RAFFLESIA))).ordinal();
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.func_176201_c(state) == EnumDirectional.UP.ordinal() || this.func_176201_c(state) == EnumDirectional.DOWN.ordinal();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWeatherflesia();
    }
}

