/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.data;

import com.bafomdad.uniquecrops.data.UCWorldData;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class UCDataHandler {
    private static UCDataHandler INSTANCE;
    private ConcurrentHashMap<Integer, Set<ChunkPos>> saveInfo = new ConcurrentHashMap();

    public static UCDataHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UCDataHandler();
        }
        return INSTANCE;
    }

    public Set<ChunkPos> getChunkInfo(int dimId) {
        if (this.saveInfo.get(dimId) == null) {
            HashSet save = new HashSet();
            this.saveInfo.put(dimId, save);
            this.saveInfo.get(dimId).add(new ChunkPos(0, 0));
        }
        return this.saveInfo.get(dimId);
    }

    public void addChunk(int dimId, ChunkPos pos, boolean dirty) {
        if (!this.getChunkInfo(dimId).contains(pos)) {
            this.getChunkInfo(dimId).add(pos);
        }
        if (dirty) {
            UCWorldData.getInstance(dimId).func_76186_a(true);
        }
    }

    public void removeChunk(int dimId, ChunkPos pos, boolean dirty) {
        this.getChunkInfo(dimId).remove(pos);
        if (dirty) {
            UCWorldData.getInstance(dimId).func_76186_a(true);
        }
    }

    public synchronized Set<ChunkPos> getSavedChunks(World world, ChunkPos pos) {
        if (world == null) {
            return null;
        }
        Set<ChunkPos> info = this.getChunkInfo(world.field_73011_w.getDimension());
        if (info.contains(pos) && info.size() > 0) {
            return info;
        }
        return null;
    }

    public void clearQueue(int dimId) {
        this.getChunkInfo(dimId).clear();
    }

    public Set<Integer> getUnsavedDims() {
        return this.saveInfo.keySet();
    }
}

