/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.dimension;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class CropTerrainGenerator {
    private double[] densities;
    private long seed = 8191L;
    private final Random rand = new Random((this.seed + 516L) * 314L);
    private NoiseGeneratorOctaves noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
    private NoiseGeneratorOctaves noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
    private NoiseGeneratorOctaves noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
    private NoiseGeneratorOctaves noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
    private NoiseGeneratorOctaves noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;
    private final double maxFactor;
    private final double minFactor;
    private final int offset;

    public CropTerrainGenerator() {
        this.maxFactor = -600.0;
        this.minFactor = -200.0;
        this.offset = 11;
    }

    private double[] initializeNoiseField(double[] densities, int chunkX, int chunkY, int chunkZ, int sizeX, int sizeY, int sizeZ) {
        if (densities == null) {
            densities = new double[sizeX * sizeY * sizeZ];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noiseData4 = this.noiseGen4.func_76305_a(this.noiseData4, chunkX, chunkZ, sizeX, sizeZ, 1.121, 1.121, 0.5);
        this.noiseData5 = this.noiseGen5.func_76305_a(this.noiseData5, chunkX, chunkZ, sizeX, sizeZ, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, chunkX, chunkY, chunkZ, sizeX, sizeY, sizeZ, (d0 *= 2.0) / 80.0, d1 / 160.0, d0 / 80.0);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, chunkX, chunkY, chunkZ, sizeX, sizeY, sizeZ, d0, d1, d0);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, chunkX, chunkY, chunkZ, sizeX, sizeY, sizeZ, d0, d1, d0);
        int k1 = 0;
        Random random = new Random(chunkX * 13 + chunkY * 157 + chunkZ * 13883);
        random.nextFloat();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                float f2 = -20.0f;
                for (int y = 0; y < sizeY; ++y) {
                    double d10;
                    double d5 = 0.0;
                    double d7 = this.noiseData2[k1] / 512.0;
                    double d8 = this.noiseData3[k1] / 512.0;
                    double d9 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d5 = d9 < 0.0 ? d7 : (d9 > 1.0 ? d8 : d7 + (d8 - d7) * d9);
                    d5 -= 8.0;
                    d5 += (double)f2;
                    int b0 = 2;
                    if (y > sizeY / 2 - b0) {
                        d10 = (float)(y - (sizeY / 2 - b0)) / 64.0f;
                        if (d10 < 0.0) {
                            d10 = 0.0;
                        } else if (d10 > 1.0) {
                            d10 = 1.0;
                        }
                        d5 = d5 * (1.0 - d10) + this.maxFactor * d10;
                    }
                    if (y < (b0 = this.offset)) {
                        d10 = (float)(b0 - y) / ((float)b0 - 1.0f);
                        d5 = d5 * (1.0 - d10) + this.minFactor * d10;
                    }
                    densities[k1] = d5;
                    ++k1;
                }
            }
        }
        return densities;
    }

    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        int b0 = 2;
        int k = b0 + 1;
        int b1 = 33;
        int l = b0 + 1;
        this.densities = this.initializeNoiseField(this.densities, chunkX * b0, 0, chunkZ * b0, k, b1, l);
        for (int x2 = 0; x2 < b0; ++x2) {
            for (int z2 = 0; z2 < b0; ++z2) {
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d0 = 0.25;
                    double d1 = this.densities[((x2 + 0) * l + z2 + 0) * b1 + height32 + 0];
                    double d2 = this.densities[((x2 + 0) * l + z2 + 1) * b1 + height32 + 0];
                    double d3 = this.densities[((x2 + 1) * l + z2 + 0) * b1 + height32 + 0];
                    double d4 = this.densities[((x2 + 1) * l + z2 + 1) * b1 + height32 + 0];
                    double d5 = (this.densities[((x2 + 0) * l + z2 + 0) * b1 + height32 + 1] - d1) * d0;
                    double d6 = (this.densities[((x2 + 0) * l + z2 + 1) * b1 + height32 + 1] - d2) * d0;
                    double d7 = (this.densities[((x2 + 1) * l + z2 + 0) * b1 + height32 + 1] - d3) * d0;
                    double d8 = (this.densities[((x2 + 1) * l + z2 + 1) * b1 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int height = height32 * 4 + h;
                        for (int x = 0; x < 8; ++x) {
                            int index = x + x2 * 8 << 12 | 0 + z2 * 8 << 8 | height;
                            int maxheight = 256;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int z = 0; z < 8; ++z) {
                                if (d15 > 0.0) {
                                    primer.func_177855_a(x, index, z, Blocks.field_150346_d.func_176223_P());
                                } else {
                                    primer.func_177855_a(x, index, z, Blocks.field_150350_a.func_176223_P());
                                }
                                index += maxheight;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }
}

