/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.events;

import com.bafomdad.uniquecrops.api.IBookUpgradeable;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.core.UCDyePlantStitch;
import com.bafomdad.uniquecrops.core.UCInvisibiliaStitch;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.entities.EntityBattleCrop;
import com.bafomdad.uniquecrops.entities.EntityItemCooking;
import com.bafomdad.uniquecrops.entities.EntityMirror;
import com.bafomdad.uniquecrops.entities.EntityMovingCrop;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.init.UCKeys;
import com.bafomdad.uniquecrops.init.UCPotions;
import com.bafomdad.uniquecrops.init.UCSounds;
import com.bafomdad.uniquecrops.items.ItemGeneric;
import com.bafomdad.uniquecrops.network.PacketSendKey;
import com.bafomdad.uniquecrops.network.UCPacketHandler;
import com.bafomdad.uniquecrops.render.ClientMethodHandles;
import com.bafomdad.uniquecrops.render.UCParticleSpawner;
import com.bafomdad.uniquecrops.render.entity.RenderBattleCropEntity;
import com.bafomdad.uniquecrops.render.entity.RenderCookingItem;
import com.bafomdad.uniquecrops.render.entity.RenderMirrorEntity;
import com.bafomdad.uniquecrops.render.entity.RenderMovingCrop;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;

public class UCEventHandlerClient {
    private static final String[] FIELD = new String[]{"mapRegisteredSprites", "field_110574_e", "bwd"};

    @SubscribeEvent
    public void loadTextures(TextureStitchEvent.Pre event) {
        try {
            Map mapRegisteredSprites = (Map)ReflectionHelper.getPrivateValue(TextureMap.class, (Object)event.getMap(), (String[])FIELD);
            for (int i = 1; i < 6; ++i) {
                mapRegisteredSprites.put("uniquecrops:blocks/invisibilia" + i, new UCInvisibiliaStitch("uniquecrops:blocks/invisibilia" + i));
            }
            mapRegisteredSprites.put("uniquecrops:blocks/dyeplant5", new UCDyePlantStitch("uniquecrops:blocks/dyeplant5"));
            mapRegisteredSprites.put("uniquecrops:blocks/invisiglass", new UCInvisibiliaStitch("uniquecrops:blocks/invisiglass"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void handleKeyPressed(InputEvent.KeyInputEvent event) {
        if (UCKeys.pixelKey.func_151468_f()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player instanceof FakePlayer) {
                return;
            }
            if (player.field_71071_by.func_70440_f(3).func_77973_b() != UCItems.pixelGlasses) {
                return;
            }
            UCPacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendKey());
        }
    }

    @SubscribeEvent
    public void showTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150474_ac)) {
            return;
        }
        ItemStack tooltipper = event.getItemStack();
        if (!tooltipper.func_77942_o() || tooltipper.func_77942_o() && !tooltipper.func_77978_p().func_74764_b("Spawner")) {
            return;
        }
        NBTTagCompound tag = tooltipper.func_77978_p().func_74775_l("Spawner");
        event.getToolTip().add("Mob spawner data:");
        event.getToolTip().add(TextFormatting.GOLD + tag.func_74775_l("SpawnData").func_74779_i("id"));
    }

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("uniquecrops-particles");
        UCParticleSpawner.dispatch();
        profiler.func_76319_b();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack glasses = player.field_71071_by.func_70440_f(3);
        if (glasses.func_77973_b() == UCItems.pixelGlasses) {
            boolean flag = NBTUtils.getBoolean(glasses, "isActive", false);
            boolean flag2 = ((IBookUpgradeable)UCItems.pixelGlasses).isMaxLevel(glasses);
            if (flag && flag2) {
                GlStateManager.func_179094_E();
                GL11.glPushAttrib((int)64);
                GlStateManager.func_179097_i();
                GlStateManager.func_179147_l();
                BlockPos pos = BlockPos.func_177969_a((long)NBTUtils.getLong(glasses, "orePos", BlockPos.field_177992_a.func_177986_g()));
                if (!pos.equals((Object)BlockPos.field_177992_a)) {
                    player.getEntityData().func_74772_a("orePos", pos.func_177986_g());
                    this.renderOres(pos, mc);
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179084_k();
                GL11.glPopAttrib();
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderOres(BlockPos pos, Minecraft mc) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        try {
            renderPosX = ClientMethodHandles.renderPosX_getter.invokeExact(mc.func_175598_ae());
            renderPosY = ClientMethodHandles.renderPosY_getter.invokeExact(mc.func_175598_ae());
            renderPosZ = ClientMethodHandles.renderPosZ_getter.invokeExact(mc.func_175598_ae());
        }
        catch (Throwable t) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - renderPosX), (double)((double)pos.func_177956_o() - renderPosY), (double)((double)pos.func_177952_p() - renderPosZ));
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRendererDispatcher brd = mc.func_175602_ab();
        brd.func_175016_a(Blocks.field_192433_dH.func_176223_P(), 1.0f);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("uniquecrops")) {
            ConfigManager.sync((String)"uniquecrops", (Config.Type)Config.Type.INSTANCE);
            UCConfig.syncMultiblocks();
        }
    }

    @SubscribeEvent
    public void registerColors(ColorHandlerEvent.Item event) {
        ItemColors ic = event.getItemColors();
        ic.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!stack.func_190926_b()) {
                    if ((stack.func_77973_b() instanceof ItemGeneric && stack.func_77952_i() == EnumItems.POTIONSPLASH.ordinal() || stack.func_77973_b() == UCItems.potionReverse) && tintIndex == 0) {
                        return 8674344;
                    }
                    if (stack.func_77973_b() == UCItems.potionEnnui && tintIndex == 0) {
                        return UCPotions.ENNUI.func_76401_j();
                    }
                    if (stack.func_77973_b() == UCItems.potionIgnorance && tintIndex == 0) {
                        return UCPotions.IGNORANCE.func_76401_j();
                    }
                }
                return 0xFFFFFF;
            }
        }, new Item[]{UCItems.generic, UCItems.potionReverse, UCItems.potionEnnui, UCItems.potionIgnorance});
        ic.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return EnumDyeColor.func_176766_a((int)stack.func_77952_i()).func_193350_e();
            }
        }, new Item[]{UCItems.dyedBonemeal});
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        if (event.getSound() == null || event.getSound().func_184365_d() == null) {
            return;
        }
        if (event.getSound().func_147650_b().func_110623_a().equals("entity.player.hurt")) {
            boolean flag;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && (flag = mc.field_71439_g.field_71071_by.func_70431_c(new ItemStack(UCBlocks.hourglass)))) {
                event.setResultSound(null);
                mc.field_71441_e.func_184133_a((EntityPlayer)mc.field_71439_g, mc.field_71439_g.func_180425_c(), UCSounds.OOF, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        this.registerBlockModel(UCBlocks.oldCobble);
        this.registerBlockModel(UCBlocks.oldCobbleMoss);
        this.registerBlockModel(UCBlocks.oldBrick);
        this.registerBlockModel(UCBlocks.oldGravel);
        this.registerBlockModel(UCBlocks.oldGrass);
        this.registerBlockModel(UCBlocks.oldDiamond);
        this.registerBlockModel(UCBlocks.oldGold);
        this.registerBlockModel(UCBlocks.oldIron);
        this.registerBlockModel(UCBlocks.hourglass, "itemhourglass");
        this.registerBlockModel(UCBlocks.totemHead, "itemtotemhead");
        this.registerBlockModel(UCBlocks.lavaLily);
        this.registerBlockModel(UCBlocks.iceLily);
        this.registerBlockModel(UCBlocks.jungleLily);
        this.registerBlockModel(UCBlocks.teleLily);
        this.registerBlockModel(UCBlocks.darkBlock);
        this.registerBlockModel(UCBlocks.barrel, "itemabstractbarrel");
        this.registerBlockModel(UCBlocks.invisiGlass);
        this.registerBlockModel(UCBlocks.demoCord);
        this.registerBlockModel(UCBlocks.mirror);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)UCBlocks.goblet), (int)0, (ModelResourceLocation)new ModelResourceLocation("uniquecrops:goblet_empty", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)UCBlocks.goblet), (int)1, (ModelResourceLocation)new ModelResourceLocation("uniquecrops:goblet_filled", "inventory"));
        this.registerBlockModel(UCBlocks.sunBlock);
        this.registerBlockModel(UCBlocks.driedThatch);
        this.registerBlockModel(UCBlocks.normieCrate);
        this.registerBlockModel(UCBlocks.ruinedBricks);
        this.registerBlockModel(UCBlocks.ruinedBricksCarved);
        this.registerBlockModel(UCBlocks.ruinedBricksRed);
        this.registerBlockModel(UCBlocks.ruinedBricksGhost);
        this.registerBlockModel(UCBlocks.portal);
        this.registerBlockModel(UCBlocks.cocito);
        this.registerBlockModel(UCBlocks.harvestTrap, "itemharvesttrap");
        this.registerBlockModel(UCBlocks.bucketRope, "itembucketrope");
        this.registerBlockModel(UCBlocks.flywoodLog);
        this.registerCustomBlockModel(UCBlocks.flywoodLeaves, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        this.registerBlockModel(UCBlocks.flywoodSapling);
        this.registerBlockModel(UCBlocks.flywoodPlank);
        this.registerBlockModel(UCBlocks.eggBasket);
        this.registerBlockModel(UCBlocks.precisionBlock);
        this.registerBlockModel(UCBlocks.cinderTorch);
        for (Item item : UCItems.items) {
            this.registerItemModel(item);
        }
        ModelLoader.setCustomModelResourceLocation((Item)UCItems.impregnatedLeather, (int)1, (ModelResourceLocation)new ModelResourceLocation(UCItems.impregnatedLeather.getRegistryName(), "inventory"));
        RenderingRegistry.registerEntityRenderingHandler(EntityMirror.class, (IRenderFactory)RenderMirrorEntity.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(EntityBattleCrop.class, (IRenderFactory)RenderBattleCropEntity.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(EntityItemCooking.class, (IRenderFactory)RenderCookingItem.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(EntityMovingCrop.class, (IRenderFactory)RenderMovingCrop.FACTORY);
    }

    private void registerBlockModel(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    private void registerBlockModel(Block block, String resLoc) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation("uniquecrops:" + resLoc, "inventory"));
    }

    private void registerCustomBlockModel(Block block, IProperty ... propertyToIgnore) {
        StateMap stateMapper = new StateMap.Builder().func_178442_a(propertyToIgnore).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)stateMapper);
        ModelResourceLocation mrl = (ModelResourceLocation)stateMapper.func_178130_a(block).get(block.func_176223_P());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)mrl);
    }

    private void registerItemModel(Item item) {
        int i;
        if (item == UCItems.generic) {
            for (i = 0; i < EnumItems.values().length; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)UCItems.generic, (int)i, (ModelResourceLocation)new ModelResourceLocation(UCItems.generic.getRegistryName() + "." + EnumItems.values()[i].func_176610_l(), "inventory"));
            }
        }
        if (item == UCItems.dyedBonemeal) {
            for (i = 0; i < EnumDyeColor.values().length; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)UCItems.dyedBonemeal, (int)i, (ModelResourceLocation)new ModelResourceLocation(UCItems.dyedBonemeal.getRegistryName(), "inventory"));
            }
        } else if (item != UCItems.generic) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }
}

