/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.items;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.init.UCItems;
import com.google.common.collect.Multimap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ItemBrassKnuckles
extends ItemSword {
    private static final String HIT_LIST = "UC:hitList";
    private static final String HIT_ENTITY = "UC:hitEntityId";
    private static final String HIT_TIME = "UC:hitTime";
    private static final String HIT_AMOUNT = "UC:hitAmount";

    public ItemBrassKnuckles() {
        super(Item.ToolMaterial.IRON);
        this.setRegistryName("brassknuckles");
        this.func_77655_b("uniquecrops.brassknuckles");
        this.func_77637_a(UniqueCrops.TAB);
        UCItems.items.add((Item)this);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return super.func_77644_a(stack, target, attacker);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && selected) {
            ItemBrassKnuckles.removeHitEntity(stack, world, (EntityPlayer)entity);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        boolean sametool = toRepair.func_77973_b() == repair.func_77973_b();
        boolean flag = repair.func_77973_b() == Items.field_151042_j;
        return sametool || flag;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldstack, ItemStack newstack, boolean slotchanged) {
        return oldstack.func_77973_b() != newstack.func_77973_b() && !slotchanged;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)2.4f, 0));
        }
        return multimap;
    }

    public static void addHitEntity(EntityLivingBase target, ItemStack stack, long worldTime, float amount) {
        NBTTagList tagList;
        NBTTagList nBTTagList = tagList = stack.func_77942_o() ? stack.func_77978_p().func_150295_c(HIT_LIST, 10) : null;
        if (tagList == null) {
            tagList = new NBTTagList();
        }
        if (tagList.func_74745_c() >= 5) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(HIT_ENTITY, target.func_145782_y());
        nbt.func_74772_a(HIT_TIME, worldTime);
        nbt.func_74776_a(HIT_AMOUNT, amount);
        tagList.func_74742_a((NBTBase)nbt);
        NBTUtils.setList(stack, HIT_LIST, tagList);
    }

    public static void removeHitEntity(ItemStack stack, World world, EntityPlayer player) {
        NBTTagList tagList;
        NBTTagList nBTTagList = tagList = stack.func_77942_o() ? stack.func_77978_p().func_150295_c(HIT_LIST, 10) : null;
        if (tagList == null || tagList.func_82582_d()) {
            return;
        }
        long worldTime = world.func_82737_E();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            EntityLivingBase elb;
            NBTTagCompound nbt = tagList.func_150305_b(i);
            long time = nbt.func_74763_f(HIT_TIME);
            if (worldTime - time <= 20L) continue;
            if (worldTime - time < 25L && (elb = (EntityLivingBase)world.func_73045_a(nbt.func_74762_e(HIT_ENTITY))) != null) {
                elb.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), nbt.func_74760_g(HIT_AMOUNT));
            }
            tagList.func_74744_a(i);
            NBTUtils.setList(stack, HIT_LIST, tagList);
            break;
        }
    }
}

