/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.items;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorfulCube
extends Item {
    public ItemColorfulCube() {
        this.setRegistryName("rubikscube");
        this.func_77655_b("uniquecrops.rubikscube");
        this.func_77637_a(UniqueCrops.TAB);
        this.func_77625_d(1);
        UCItems.items.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag whatisthis) {
        super.func_77624_a(stack, player, list, whatisthis);
        list.add(I18n.func_135052_a((String)"uniquecrops.tooltip.rubikscube", (Object[])new Object[0]));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == this && !player.func_184811_cZ().func_185141_a((Item)this)) {
            player.openGui((Object)UniqueCrops.instance, 5, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_73011_w.getDimension() == 0 && player.func_70093_af() && facing == EnumFacing.UP) {
            ItemStack stack = player.func_184586_b(hand);
            int rot = this.getRotation(stack);
            BlockPos savedPos = pos.func_177984_a();
            if (!world.field_72995_K) {
                this.savePosition(stack, rot, savedPos);
                player.func_145747_a((ITextComponent)new TextComponentString("Teleport position saved"));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void saveRotation(ItemStack stack, int rotation) {
        NBTUtils.setInt(stack, "UC_RubiksCubeRotation", rotation);
    }

    public int getRotation(ItemStack stack) {
        return NBTUtils.getInt(stack, "UC_RubiksCubeRotation", 2);
    }

    public void savePosition(ItemStack stack, int rotation, BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("UC_RubiksCubeSavedPos", pos.func_177986_g());
        NBTUtils.setCompound(stack, "UC_RubiksCubeRotation" + rotation, tag);
    }

    public BlockPos getSavedPosition(ItemStack stack, int rotation) {
        NBTTagCompound tag = NBTUtils.getCompound(stack, "UC_RubiksCubeRotation" + rotation, true);
        if (tag != null && tag.func_74764_b("UC_RubiksCubeSavedPos")) {
            return BlockPos.func_177969_a((long)tag.func_74763_f("UC_RubiksCubeSavedPos"));
        }
        return BlockPos.field_177992_a;
    }

    public void teleportToPosition(EntityPlayer player, int rotation, boolean teleport) {
        if (player.field_70170_p.field_73011_w.getDimension() != 0) {
            player.func_146105_b((ITextComponent)new TextComponentString("Not in the overworld!"), true);
            return;
        }
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_190926_b() || stack.func_77973_b() != this) continue;
            if (!teleport) {
                this.saveRotation(stack, rotation);
                return;
            }
            BlockPos pos = this.getSavedPosition(stack, rotation);
            if (!pos.equals((Object)BlockPos.field_177992_a)) {
                player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                player.field_70170_p.func_175718_b(2003, pos, 0);
                player.func_184811_cZ().func_185145_a((Item)this, UCConfig.cubeCooldown);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("No teleport position saved here!"), true);
            }
            this.saveRotation(stack, rotation);
            break;
        }
    }
}

