/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.api.deathchest;

import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import com.therandomlabs.vanilladeathchest.api.event.DeathChestRemoveEvent;
import com.therandomlabs.vanilladeathchest.world.storage.VDCSavedData;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class DeathChestManager {
    private DeathChestManager() {
    }

    public static void addDeathChest(World world, EntityPlayer player, BlockPos pos, boolean isDoubleChest) {
        VDCSavedData data = VDCSavedData.get(world);
        Map<BlockPos, DeathChest> deathChests = data.getDeathChests();
        DeathChest deathChest = new DeathChest(world, player.func_110124_au(), world.func_82737_E(), pos, isDoubleChest, false);
        deathChests.put(pos, deathChest);
        if (isDoubleChest) {
            deathChests.put(pos.func_177974_f(), deathChest);
        }
        data.func_76185_a();
    }

    public static boolean isDeathChest(World world, BlockPos pos) {
        return DeathChestManager.getDeathChest(world, pos) != null;
    }

    public static boolean isLocked(World world, BlockPos pos) {
        DeathChest deathChest = DeathChestManager.getDeathChest(world, pos);
        return deathChest != null && !deathChest.isUnlocked();
    }

    public static DeathChest getDeathChest(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != Blocks.field_150486_ae && !(block instanceof BlockShulkerBox)) {
            return null;
        }
        Map<BlockPos, DeathChest> deathChests = VDCSavedData.get(world).getDeathChests();
        return deathChests.get(pos);
    }

    public static DeathChest removeDeathChest(World world, BlockPos pos) {
        BlockPos east;
        BlockPos west;
        Map<BlockPos, DeathChest> deathChests = VDCSavedData.get(world).getDeathChests();
        DeathChest chest = deathChests.remove(pos);
        if (chest == null) {
            return null;
        }
        if (chest.isDoubleChest()) {
            if (chest.getPos().equals((Object)pos)) {
                west = pos;
                east = pos.func_177974_f();
            } else {
                west = pos.func_177976_e();
                east = pos;
            }
        } else {
            west = pos;
            east = null;
        }
        MinecraftForge.EVENT_BUS.post((Event)new DeathChestRemoveEvent(chest, west, east));
        return chest;
    }
}

