/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChestManager;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import com.therandomlabs.vanilladeathchest.gamestages.VDCStageInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="vanilladeathchest")
public final class DeathChestInteractionHandler {
    private static BlockPos harvesting;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        if (harvesting == pos) {
            return;
        }
        DeathChest deathChest = DeathChestManager.getDeathChest(world, pos);
        if (deathChest == null) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        if (!DeathChestInteractionHandler.canInteract(player, deathChest)) {
            event.setCanceled(true);
            return;
        }
        DeathChest chest = DeathChestManager.removeDeathChest(world, pos);
        if (chest.isDoubleChest()) {
            harvesting = chest.getPos().equals((Object)pos) ? pos.func_177974_f() : pos.func_177976_e();
            player.field_71134_c.func_180237_b(harvesting);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        DeathChest deathChest = DeathChestManager.getDeathChest(world, event.getPos());
        if (deathChest == null) {
            return;
        }
        if (!DeathChestInteractionHandler.canInteract((EntityPlayerMP)event.getEntityPlayer(), deathChest)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        event.getAffectedBlocks().removeIf(pos -> DeathChestManager.isLocked(world, pos));
    }

    private static boolean canInteract(EntityPlayerMP player, DeathChest deathChest) {
        String message;
        if (!deathChest.canInteract((EntityPlayer)player)) {
            return false;
        }
        VDCStageInfo info = VDCStageInfo.get((EntityPlayer)player);
        Item unlocker = info.getUnlocker();
        if (unlocker == null || deathChest.isUnlocked()) {
            return true;
        }
        ItemStack stack = player.func_184586_b(player.func_184600_cs());
        int amount = info.getUnlockerConsumeAmount();
        if (stack.func_77973_b() == unlocker) {
            if (amount == 0) {
                deathChest.setUnlocked(true);
                return true;
            }
            if (info.damageUnlockerInsteadOfConsume()) {
                boolean unlocked = player.field_71075_bZ.field_75098_d;
                if (!unlocked && stack.func_77984_f() && stack.func_77952_i() + amount < stack.func_77958_k()) {
                    stack.func_96631_a(amount, player.func_70681_au(), player);
                    unlocked = true;
                }
                if (unlocked) {
                    deathChest.setUnlocked(true);
                    return true;
                }
            } else if (stack.func_190916_E() >= amount) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(amount);
                }
                deathChest.setUnlocked(true);
                return true;
            }
        }
        if (!(message = info.getUnlockFailedMessage()).isEmpty()) {
            TextComponentString component = new TextComponentString(String.format(message, amount, new TextComponentTranslation(unlocker.func_77658_a() + ".name", new Object[0]).func_150254_d().trim()));
            if (VDCConfig.Defense.unlockFailedStatusMessage) {
                player.func_146105_b((ITextComponent)component, true);
            } else {
                player.func_145747_a((ITextComponent)component);
            }
        }
        return false;
    }
}

