/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.config;

import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.CompatForgeRegistry;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.CompatForgeRegistryEntry;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.config.Config;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.config.ConfigManager;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.config.TRLCategory;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.config.adapter.TRLTypeAdapter;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.config.adapter.TRLTypeAdapters;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

final class TRLProperty {
    private static boolean canSetValidValuesDisplay = true;
    final TRLCategory category;
    final String name;
    final Field field;
    final String languageKey;
    final String previousName;
    final String previousCategory;
    final TRLTypeAdapter adapter;
    final Class<?> clazz;
    final Property.Type type;
    final boolean isArray;
    final boolean isResourceLocation;
    final Class<?> enumClass;
    final Enum[] enumConstants;
    final String[] validValues;
    final String[] validValuesDisplay;
    final boolean nonNull;
    final boolean requiresMCRestart;
    final boolean requiresWorldReload;
    final double min;
    final double max;
    final String[] blacklist;
    final String comment;
    final String commentOnDisk;
    Object defaultValue;

    TRLProperty(TRLCategory category, String name, Field field, String comment, String previous) {
        double largestMax;
        double smallestMin;
        this.category = category;
        this.name = name;
        this.field = field;
        this.languageKey = this.category.getLanguageKeyPrefix() + name;
        if (previous == null) {
            this.previousName = null;
            this.previousCategory = null;
        } else {
            Object[] data = StringUtils.split((String)previous, (char)'.');
            this.previousName = data[data.length - 1];
            this.previousCategory = StringUtils.join((Object[])data, (char)'.', (int)0, (int)(data.length - 1));
        }
        this.clazz = field.getType();
        if (Enum.class.isAssignableFrom(this.clazz)) {
            this.enumClass = this.clazz;
            this.adapter = TRLTypeAdapters.get(String.class);
        } else if (Enum[].class.isAssignableFrom(this.clazz)) {
            this.enumClass = this.clazz.getComponentType();
            this.adapter = TRLTypeAdapters.get(String[].class);
        } else {
            this.enumClass = null;
            this.adapter = TRLTypeAdapters.get(this.clazz);
        }
        if (this.adapter == null) {
            throw new UnsupportedOperationException("Invalid configuration property type: " + this.clazz.getName());
        }
        if (this.enumClass == null) {
            this.enumConstants = null;
            this.validValues = null;
            this.validValuesDisplay = null;
        } else {
            ArrayList<String> validValues = new ArrayList<String>();
            ArrayList<String> validValuesDisplay = new ArrayList<String>();
            for (Enum element : this.enumConstants = (Enum[])this.enumClass.getEnumConstants()) {
                validValues.add(element.name());
                validValuesDisplay.add(element.toString());
            }
            this.validValues = validValues.toArray(new String[0]);
            this.validValuesDisplay = validValuesDisplay.toArray(new String[0]);
        }
        this.type = this.adapter.getType();
        this.isArray = this.adapter.isArray();
        this.isResourceLocation = CompatForgeRegistryEntry.CLASS != null && CompatForgeRegistryEntry.CLASS.isAssignableFrom(this.clazz);
        Object defaultValue = null;
        try {
            defaultValue = field.get(null);
        }
        catch (IllegalAccessException ex) {
            TRLUtils.crashReport("Failed to load default value of configuration property", ex);
        }
        boolean bl = this.nonNull = field.getAnnotation(Config.NonNull.class) != null;
        if (defaultValue == null && (!this.isResourceLocation || this.nonNull)) {
            throw new IllegalArgumentException("Default value of configuration property may not be null unless it is a registry entry without the @Config.NonNull annotation");
        }
        this.defaultValue = defaultValue;
        this.requiresMCRestart = field.getAnnotation(Config.RequiresMCRestart.class) != null;
        boolean bl2 = this.requiresWorldReload = field.getAnnotation(Config.RequiresWorldReload.class) != null;
        if (this.requiresMCRestart && this.requiresWorldReload) {
            throw new IllegalArgumentException("A property cannot both require a Minecraft restart and a world reload");
        }
        if (defaultValue instanceof Byte) {
            smallestMin = -128.0;
            largestMax = 127.0;
        } else if (defaultValue instanceof Float) {
            smallestMin = -3.4028234663852886E38;
            largestMax = 3.4028234663852886E38;
        } else if (defaultValue instanceof Integer) {
            smallestMin = -2.147483648E9;
            largestMax = 2.147483647E9;
        } else if (defaultValue instanceof Long) {
            smallestMin = -9.223372036854776E18;
            largestMax = 9.223372036854776E18;
        } else if (defaultValue instanceof Short) {
            smallestMin = -32768.0;
            largestMax = 32767.0;
        } else {
            smallestMin = -1.7976931348623157E308;
            largestMax = Double.MAX_VALUE;
        }
        Config.RangeInt rangeInt = field.getAnnotation(Config.RangeInt.class);
        Config.RangeDouble rangeDouble = field.getAnnotation(Config.RangeDouble.class);
        double min = -1.7976931348623157E308;
        double max = Double.MAX_VALUE;
        if (rangeInt != null) {
            if (rangeDouble != null) {
                throw new IllegalArgumentException("Two ranges cannot be defined");
            }
            min = rangeInt.min();
            max = rangeInt.max();
            if (min == -2.147483648E9 && min < smallestMin) {
                min = smallestMin;
            }
            if (max == 2.147483647E9 && max > largestMax) {
                max = largestMax;
            }
            if (min > max) {
                throw new IllegalArgumentException("min cannot be larger than max");
            }
        } else if (rangeDouble != null) {
            min = rangeDouble.min();
            max = rangeDouble.max();
            if (min == -1.7976931348623157E308) {
                min = smallestMin;
            }
            if (max == Double.MAX_VALUE) {
                max = largestMax;
            }
            if (min > max) {
                throw new IllegalArgumentException("min cannot be larger than max");
            }
        }
        if (min == -1.7976931348623157E308) {
            min = smallestMin;
        }
        if (max == Double.MAX_VALUE) {
            max = largestMax;
        }
        if (min < smallestMin) {
            throw new IllegalArgumentException(String.format("min is too small: %s < %s", min, smallestMin));
        }
        if (max > largestMax) {
            throw new IllegalArgumentException(String.format("max is too large: %s > %s", max, largestMax));
        }
        this.min = min;
        this.max = max;
        Config.Blacklist blacklist = field.getAnnotation(Config.Blacklist.class);
        String[] stringArray = this.blacklist = blacklist == null ? new String[]{} : blacklist.value();
        if (this.isArray) {
            for (Object element : TRLUtils.toBoxedArray(defaultValue)) {
                if (!ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(element))) continue;
                throw new IllegalArgumentException("Default value is blacklisted");
            }
        } else if (ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(defaultValue))) {
            throw new IllegalArgumentException("Default value is blacklisted");
        }
        this.comment = comment;
        StringBuilder commentOnDisk = new StringBuilder(comment);
        if (this.enumConstants != null) {
            commentOnDisk.append("\nValid values:");
            for (Enum element : this.enumConstants) {
                commentOnDisk.append("\n").append(element.name());
            }
        }
        if (defaultValue instanceof Number) {
            if (defaultValue instanceof Double || defaultValue instanceof Float) {
                commentOnDisk.append("\nMin: ").append(min).append("\nMax: ").append(max);
            } else {
                commentOnDisk.append("\nMin: ").append((long)min).append("\nMax: ").append((long)max);
            }
        }
        if (this.blacklist.length != 0) {
            commentOnDisk.append("\nBlacklist: ").append(Arrays.toString(this.blacklist));
        }
        commentOnDisk.append("\nDefault: ");
        if (this.isArray) {
            commentOnDisk.append(Arrays.stream(TRLUtils.toBoxedArray(defaultValue)).map(this.adapter::asString).collect(Collectors.toList()));
        } else {
            commentOnDisk.append(this.adapter.asString(defaultValue));
        }
        this.commentOnDisk = commentOnDisk.toString();
    }

    void reloadDefault() {
        if (!this.isArray) {
            if (this.defaultValue != null) {
                CompatForgeRegistry<?> registry = CompatForgeRegistry.findRegistry(this.clazz);
                this.defaultValue = registry.getValue(new CompatForgeRegistryEntry(this.defaultValue).getRegistryName());
            }
            return;
        }
        Object[] oldDefaults = (Object[])this.defaultValue;
        ArrayList newDefaults = new ArrayList(oldDefaults.length);
        CompatForgeRegistry<?> registry = CompatForgeRegistry.findRegistry(this.clazz.getComponentType());
        for (Object oldDefault : oldDefaults) {
            newDefaults.add(registry.getValue(new CompatForgeRegistryEntry(oldDefault).getRegistryName()));
        }
        this.defaultValue = newDefaults.toArray(Arrays.copyOf(oldDefaults, 0));
    }

    boolean exists(Configuration config) {
        return config.getCategory(this.category.name).get(this.name) != null || this.getPrevious(config) != null;
    }

    Property getPrevious(Configuration config) {
        if (this.previousName == null || !config.hasCategory(this.previousCategory)) {
            return null;
        }
        Property property = config.getCategory(this.previousCategory).get(this.previousName);
        return property != null && property.getType() == this.type ? property : null;
    }

    Property get(Configuration config) {
        ConfigCategory category = this.category.get(config);
        Property property = category.get(this.name);
        if (property == null) {
            property = this.getPrevious(config);
            if (property == null) {
                property = this.isArray ? new Property(this.name, new String[0], this.type) : new Property(this.name, (String)null, this.type);
            }
            category.put(this.name, property);
        }
        ConfigManager.setComment(property, this.comment);
        property.setLanguageKey(this.languageKey);
        if (this.enumClass == null) {
            this.adapter.setDefaultValue(property, this.defaultValue);
        } else if (this.isArray) {
            property.setDefaultValues((String[])Arrays.stream((Enum[])this.defaultValue).map(Enum::name).toArray(String[]::new));
        } else {
            property.setDefaultValue(((Enum)this.defaultValue).name());
        }
        property.setValidValues(this.validValues);
        if (TRLUtils.MC_VERSION_NUMBER > 11 && canSetValidValuesDisplay) {
            try {
                property.setValidValuesDisplay(this.validValuesDisplay);
            }
            catch (NoSuchMethodError e) {
                canSetValidValuesDisplay = false;
            }
        }
        if (this.defaultValue instanceof Double || this.defaultValue instanceof Float) {
            property.setMinValue(this.min);
            property.setMaxValue(this.max);
        } else if (this.defaultValue instanceof Number) {
            property.setMinValue((int)this.min);
            property.setMaxValue((int)this.max);
        }
        return property;
    }

    Object validate(Object value, boolean isArray) {
        if (value == null && !this.isResourceLocation) {
            value = this.defaultValue;
        }
        if (isArray) {
            boolean primitive = !(value instanceof Object[]);
            Object[] boxedArray = TRLUtils.toBoxedArray(value);
            ArrayList<Object> filtered = new ArrayList<Object>();
            for (Object element : boxedArray) {
                Object validated;
                if (element == null || (validated = this.validate(element, false)) == null) continue;
                filtered.add(validated);
            }
            Object[] filteredArray = filtered.toArray(Arrays.copyOf(boxedArray, 0));
            return primitive ? TRLUtils.toPrimitiveArray(filteredArray) : filteredArray;
        }
        if (ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(value))) {
            return null;
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            if (number < this.min) {
                number = this.min;
            } else if (number > this.max) {
                number = this.max;
            }
            if (value instanceof Byte) {
                return (byte)number;
            }
            if (value instanceof Double) {
                return number;
            }
            if (value instanceof Float) {
                return Float.valueOf((float)number);
            }
            if (value instanceof Integer) {
                return (int)number;
            }
            if (value instanceof Long) {
                return (long)number;
            }
            if (value instanceof Short) {
                return (short)number;
            }
        }
        return value;
    }

    Property serialize(Configuration config) throws IllegalAccessException {
        Property property = this.get(config);
        Object value = this.validate(this.field.get(null), this.isArray);
        if (value == null) {
            value = this.defaultValue;
        }
        if (this.enumConstants == null) {
            this.adapter.setValue(property, value);
            return property;
        }
        if (!this.isArray) {
            property.setValue(((Enum)value).name());
            return property;
        }
        property.setValues((String[])Arrays.stream((Enum[])value).map(Enum::name).toArray(String[]::new));
        return property;
    }

    Property deserialize(Configuration config) throws IllegalAccessException {
        Property property = this.get(config);
        if (this.enumConstants == null) {
            Object value = this.adapter.getValue(property);
            if (this.nonNull && value == null) {
                this.field.set(null, this.defaultValue);
            } else {
                Object validated = this.validate(value, this.isArray);
                this.field.set(null, validated == null ? this.defaultValue : validated);
            }
            return property;
        }
        if (!this.isArray) {
            String value = StringUtils.remove((String)property.getString(), (char)'_');
            for (Enum element : this.enumConstants) {
                if (!StringUtils.remove((String)element.name(), (char)'_').equalsIgnoreCase(value)) continue;
                this.field.set(null, element);
                return property;
            }
            this.field.set(null, this.defaultValue);
            return property;
        }
        String[] values = property.getStringList();
        ArrayList<Enum> enumValues = new ArrayList<Enum>(values.length);
        block1: for (String value : values) {
            value = StringUtils.remove((String)value, (char)'_');
            for (Enum element : this.enumConstants) {
                if (!StringUtils.remove((String)element.name(), (char)'_').equalsIgnoreCase(value)) continue;
                enumValues.add(element);
                continue block1;
            }
        }
        this.field.set(null, enumValues.toArray((Object[])Array.newInstance(this.enumClass, 0)));
        return property;
    }
}

