/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.client;

import com.jozufozu.yoyos.common.EntityYoyo;
import com.jozufozu.yoyos.common.RenderOrientation;
import com.jozufozu.yoyos.common.api.IYoyo;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderYoYo
extends Render<EntityYoyo> {
    private RenderItem itemRenderer;
    private Random random = new Random();
    private EntityLivingBase dummy;

    public RenderYoYo(RenderManager renderManager) {
        super(renderManager);
        this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
    }

    public boolean shouldRender(EntityYoyo livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public void doRender(EntityYoyo entityYoyo, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.dummy == null || this.dummy.field_70170_p != entityYoyo.field_70170_p) {
            this.dummy = new EntityBat(entityYoyo.field_70170_p);
        }
        Profiler mcProfiler = Minecraft.func_71410_x().field_71424_I;
        mcProfiler.func_76320_a("renderYoyo");
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)(entityYoyo.field_70131_O / 2.0f)), (double)z);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        double yoyoPosX = RenderYoYo.interpolateValue(entityYoyo.field_70169_q, entityYoyo.field_70165_t, (double)partialTicks);
        double yoyoPosY = RenderYoYo.interpolateValue(entityYoyo.field_70167_r, entityYoyo.field_70163_u, (double)partialTicks) - (double)entityYoyo.field_70131_O;
        double yoyoPosZ = RenderYoYo.interpolateValue(entityYoyo.field_70166_s, entityYoyo.field_70161_v, (double)partialTicks);
        Vec3d pointTo = entityYoyo.getPlayerHandPos(partialTicks).func_178786_a(yoyoPosX, yoyoPosY, yoyoPosZ).func_72432_b();
        float yaw = (float)(Math.atan2(pointTo.field_72450_a, pointTo.field_72449_c) * -180.0 / Math.PI);
        GlStateManager.func_179094_E();
        if (entityYoyo.getYoyo() != null && entityYoyo.getYoyo().getRenderOrientation(entityYoyo.getYoyoStack()) == RenderOrientation.Horizontal) {
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(270.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)entityYoyo.getRotation(entityYoyo.field_70173_aa, partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c(entityYoyo));
        }
        this.itemRenderer.func_184392_a(entityYoyo.getYoyoStack(), this.dummy, ItemCameraTransforms.TransformType.NONE, false);
        GlStateManager.func_179121_F();
        if (entityYoyo.isCollecting() && !entityYoyo.collectedDrops.isEmpty()) {
            this.renderCollectedItems(entityYoyo, partialTicks);
        }
        GlStateManager.func_179121_F();
        RenderYoYo.renderChord(entityYoyo, x, y, z, partialTicks);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        super.func_76986_a((Entity)entityYoyo, x, y, z, entityYaw, partialTicks);
        mcProfiler.func_76319_b();
    }

    public void renderCollectedItems(EntityYoyo entity, float partialTicks) {
        boolean boundTexture = false;
        if (this.func_180548_c(entity)) {
            this.field_76990_c.field_78724_e.func_110581_b(this.getEntityTexture(entity)).func_174936_b(false, false);
            boundTexture = true;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74519_b();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = 0;
        for (ItemStack drop : entity.collectedDrops) {
            int max = drop.func_77976_d();
            for (int count = drop.func_190916_E(); count > 0; count -= max) {
                this.doRenderItem(i++, entity, drop, partialTicks);
            }
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        this.func_180548_c(entity);
        if (boundTexture) {
            this.field_76990_c.field_78724_e.func_110581_b(this.getEntityTexture(entity)).func_174935_a();
        }
    }

    public static void renderChord(EntityYoyo entity, double x, double y, double z, float partialTicks) {
        Vec3d handPos;
        double posZ;
        double posY;
        double posX;
        boolean rightHand;
        Entity thrower = entity.getThrower();
        if (!(thrower instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)thrower;
        y -= (1.6 - (double)thrower.field_70131_O) * 0.5;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        boolean bl = rightHand = player.func_184591_cq() == EnumHandSide.RIGHT == (entity.getHand() == EnumHand.MAIN_HAND);
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || player.func_145782_y() != Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
            posX = RenderYoYo.interpolateValue(thrower.field_70169_q, thrower.field_70165_t, (double)partialTicks);
            posY = RenderYoYo.interpolateValue(thrower.field_70167_r, thrower.field_70163_u, (double)partialTicks) + 1.272;
            posZ = RenderYoYo.interpolateValue(thrower.field_70166_s, thrower.field_70161_v, (double)partialTicks);
            double bodyRotation = RenderYoYo.interpolateValue(player.field_70760_ar, player.field_70761_aq, partialTicks);
            double rotation = bodyRotation = Math.toRadians(bodyRotation);
            if (rightHand) {
                rotation += Math.PI;
            }
            double shoulderRadius = 0.347;
            posX += Math.cos(rotation) * 0.347;
            posZ += Math.sin(rotation) * 0.347;
            double f = 1.0;
            if (player.func_184599_cB() > 4) {
                f = thrower.field_70159_w * thrower.field_70159_w + thrower.field_70181_x * thrower.field_70181_x + thrower.field_70179_y * thrower.field_70179_y;
                f /= (double)0.2f;
                f = f * f * f;
            }
            if (f < 1.0) {
                f = 1.0;
            }
            float limbSwing = player.field_184619_aG;
            float limbSwingAmount = RenderYoYo.interpolateValue(player.field_184618_aE, player.field_70721_aZ, partialTicks);
            double pitch = Math.cos((double)limbSwing * 0.6662 + (rightHand ? 0.0 : Math.PI)) * 2.0 * (double)limbSwingAmount * 0.5 / f;
            pitch *= 0.1858407346410207;
            if (player.func_70093_af()) {
                pitch += 0.4;
                posY -= 0.4;
            }
            int n = rightHand ? -1 : 1;
            double roll = Math.PI;
            double yaw = bodyRotation + Math.cos((double)((float)player.field_70173_aa + partialTicks) * 0.09) * 0.05 + 0.05;
            handPos = new Vec3d(posX += -1.0 * Math.sin(roll) * Math.cos(yaw) - Math.cos(roll) * Math.sin(pitch += (double)n * Math.sin((double)((float)player.field_70173_aa + partialTicks) * 0.067) * 0.05) * Math.sin(yaw), posY += Math.cos(pitch) * Math.cos(roll), posZ += Math.sin(roll) * Math.sin(yaw) - Math.cos(roll) * Math.sin(pitch) * Math.cos(yaw));
        } else {
            posX = RenderYoYo.interpolateValue(thrower.field_70169_q, thrower.field_70165_t, (double)partialTicks);
            posY = RenderYoYo.interpolateValue(thrower.field_70167_r, thrower.field_70163_u, (double)partialTicks) + 1.1;
            posZ = RenderYoYo.interpolateValue(thrower.field_70166_s, thrower.field_70161_v, (double)partialTicks);
            double rotationYaw = Math.toRadians(RenderYoYo.interpolateValue(player.field_70126_B, player.field_70177_z, partialTicks));
            double rotationPitch = Math.toRadians(RenderYoYo.interpolateValue(player.field_70127_C, player.field_70125_A, partialTicks));
            double mirror = rightHand ? -1 : 1;
            double radius = 0.1;
            double v = -Math.sin(rotationPitch) * mirror * mirror * radius;
            double angle = rotationYaw + 1.5707963267948966;
            handPos = new Vec3d(posX += Math.cos(rotationYaw) * mirror * radius + Math.cos(angle) * v, posY += Math.sin(-rotationPitch) * radius, posZ += Math.sin(rotationYaw) * mirror * radius + Math.sin(angle) * v);
        }
        double yoyoPosX = RenderYoYo.interpolateValue(entity.field_70169_q, entity.field_70165_t, (double)partialTicks);
        double yoyoPosY = RenderYoYo.interpolateValue(entity.field_70167_r, entity.field_70163_u, (double)partialTicks) - (double)entity.field_70131_O;
        double yoyoPosZ = RenderYoYo.interpolateValue(entity.field_70166_s, entity.field_70161_v, (double)partialTicks);
        double xDiff = handPos.field_72450_a - yoyoPosX;
        double yDiff = handPos.field_72448_b - yoyoPosY;
        double zDiff = handPos.field_72449_c - yoyoPosZ;
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        int color = 0xDDDDDD;
        IYoyo yoyo = entity.getYoyo();
        if (yoyo != null) {
            color = yoyo.getCordColor(entity.getYoyoStack(), (float)entity.field_70173_aa + partialTicks);
        }
        float stringR = (float)(color >> 16 & 0xFF) / 255.0f;
        float stringG = (float)(color >> 8 & 0xFF) / 255.0f;
        float stringB = (float)(color & 0xFF) / 255.0f;
        for (int i = 0; i < 2; ++i) {
            bufferBuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int j = 0; j <= 24; ++j) {
                float r = stringR;
                float g = stringG;
                float b = stringB;
                if (j % 2 == 0) {
                    r *= 0.7f;
                    g *= 0.7f;
                    b *= 0.7f;
                }
                double segment = (double)j / 24.0;
                double zag = 0.0125 * (double)(i % 2 * 2 - 1);
                double x1 = x + xDiff * segment;
                double y1 = y + yDiff * (segment * segment + segment) * 0.5;
                double z1 = z + zDiff * segment;
                bufferBuilder.func_181662_b(x1 - 0.0125, y1, z1 + zag).func_181666_a(r, g, b, 1.0f).func_181675_d();
                bufferBuilder.func_181662_b(x1 + 0.0125, y1, z1 - zag).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
    }

    private int transformModelCount(EntityYoyo yoyo, ItemStack itemStack, float partialTicks, IBakedModel model) {
        boolean gui3d = model.func_177556_c();
        int count = this.getModelCount(itemStack);
        double bob = Math.sin((this.random.nextDouble() + (double)yoyo.field_70173_aa + (double)partialTicks) / 10.0 + this.random.nextDouble() * Math.PI * 2.0) * 0.1 + 0.1;
        double scale = model.func_177552_f().func_181688_b((ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND).field_178363_d.y;
        GlStateManager.func_179137_b((double)0.0, (double)(bob + 0.25 * scale), (double)0.0);
        if (gui3d || this.field_76990_c.field_78733_k != null) {
            double angle = ((this.random.nextDouble() + (double)yoyo.field_70173_aa + (double)partialTicks) / 20.0 + this.random.nextDouble() * Math.PI * 2.0) * 57.29577951308232;
            GlStateManager.func_179114_b((float)((float)angle), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return count;
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.func_190916_E() > 48) {
            i = 5;
        } else if (stack.func_190916_E() > 32) {
            i = 4;
        } else if (stack.func_190916_E() > 16) {
            i = 3;
        } else if (stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }

    public void doRenderItem(int i, EntityYoyo yoyo, ItemStack itemStack, float partialTicks) {
        GlStateManager.func_179094_E();
        long seed = Item.func_150891_b((Item)itemStack.func_77973_b()) << 16;
        seed |= (long)(itemStack.func_77960_j() << 12);
        this.random.setSeed(seed |= (long)i);
        IBakedModel ibakedmodel = this.itemRenderer.func_184393_a(itemStack, yoyo.field_70170_p, null);
        int modelCount = this.transformModelCount(yoyo, itemStack, partialTicks, ibakedmodel);
        boolean gui3d = ibakedmodel.func_177556_c();
        if (!gui3d) {
            float f3 = -0.0f * (float)(modelCount - 1) * 0.5f;
            float f4 = -0.0f * (float)(modelCount - 1) * 0.5f;
            float f5 = -0.09375f * (float)(modelCount - 1) * 0.5f;
            GlStateManager.func_179109_b((float)f3, (float)f4, (float)f5);
        }
        for (int k = 0; k < modelCount; ++k) {
            IBakedModel transformedModel;
            if (gui3d) {
                GlStateManager.func_179094_E();
                if (k > 0) {
                    float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    GlStateManager.func_179109_b((float)f7, (float)f9, (float)f6);
                }
                transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
                this.itemRenderer.func_180454_a(itemStack, transformedModel);
                GlStateManager.func_179121_F();
                continue;
            }
            GlStateManager.func_179094_E();
            if (k > 0) {
                float f8 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                GlStateManager.func_179109_b((float)f8, (float)f10, (float)0.0f);
            }
            transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
            this.itemRenderer.func_180454_a(itemStack, transformedModel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.09375f);
        }
        GlStateManager.func_179121_F();
    }

    private static double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    private static float interpolateValue(float start, float end, float pct) {
        return start + (end - start) * pct;
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(EntityYoyo entity) {
        return TextureMap.field_110575_b;
    }
}

