/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers.materials;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;

public class AxleMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Friction = "stat.axle.friction.name";
    public static final String LOC_FrictionDesc = "stat.axle.friction.desc";
    public static final String COLOR_Friction = CustomFontColor.encodeColor((int)74, (int)232, (int)128);
    public final float friction;
    public final float modifier;

    public AxleMaterialStats(float friction, float modifier) {
        super("axle");
        this.friction = friction;
        this.modifier = modifier;
    }

    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)AxleMaterialStats.formatFriction(this.friction), (Object)HandleMaterialStats.formatModifier((float)this.modifier));
    }

    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate((String)LOC_FrictionDesc, (Object[])new Object[0]), (Object)Util.translate((String)"stat.handle.modifier.desc", (Object[])new Object[0]));
    }

    public static String formatFriction(float friction) {
        return AxleMaterialStats.formatNumber((String)LOC_Friction, (String)COLOR_Friction, (float)friction);
    }

    @Nullable
    public static AxleMaterialStats deserialize(JsonObject material) throws JsonParseException {
        if (!JsonUtils.func_151204_g((JsonObject)material, (String)"axle")) {
            return null;
        }
        JsonObject axle = JsonUtils.func_152754_s((JsonObject)material, (String)"axle");
        float friction = JsonUtils.func_151217_k((JsonObject)axle, (String)"friction");
        float modifier = JsonUtils.func_151217_k((JsonObject)axle, (String)"modifier");
        return new AxleMaterialStats(friction, modifier);
    }
}

