/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.world.SimplexNoise;
import biomesoplenty.common.world.layer.traits.IBOPAreaTransformer0;
import biomesoplenty.common.world.layer.traits.IBOPContextExtended;
import java.util.Random;

public enum TemperatureNoiseLayer implements IBOPAreaTransformer0
{
    SMALL_ZONES(0.16),
    MEDIUM_ZONES(0.06),
    LARGE_ZONES(0.01);

    private final double scale;
    private long seed;
    private double xOffset;
    private double zOffset;

    private TemperatureNoiseLayer(double scale) {
        this.scale = scale;
    }

    @Override
    public int applyPixel(IBOPContextExtended context, int x, int z) {
        double noiseVal;
        long seed = context.getWorldSeed();
        if (this.seed != seed) {
            Random random = new Random(seed + 123L);
            this.xOffset = (random.nextDouble() - 0.5) * 8192.0;
            this.zOffset = (random.nextDouble() - 0.5) * 8192.0;
            this.seed = seed;
        }
        if ((noiseVal = SimplexNoise.noise(((double)x + this.xOffset) * this.scale, ((double)z + this.zOffset) * this.scale)) < -0.619) {
            return 0;
        }
        if (noiseVal < -0.503) {
            return 1;
        }
        if (noiseVal < -0.293) {
            return 2;
        }
        if (noiseVal < -0.12) {
            return 3;
        }
        if (noiseVal < 0.085) {
            return 4;
        }
        if (noiseVal < 0.252) {
            return 5;
        }
        if (noiseVal < 0.467) {
            return 6;
        }
        if (noiseVal < 0.619) {
            return 7;
        }
        return 8;
    }
}

