/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.RemoveWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.SortWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.RemoveWaystoneMessage;
import net.blay09.mods.waystones.network.message.RequestEditWaystoneMessage;
import net.blay09.mods.waystones.network.message.SelectWaystoneMessage;
import net.blay09.mods.waystones.network.message.SortWaystoneMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class WaystoneSelectionScreenBase
extends ContainerScreen<WaystoneSelectionContainer> {
    private final List<IWaystone> waystones;
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private Button btnPrevPage;
    private Button btnNextPage;
    private int pageOffset;
    private int headerY;
    private boolean isLocationHeaderHovered;
    private int buttonsPerPage;
    private static final int headerHeight = 40;
    private static final int footerHeight = 25;
    private static final int entryHeight = 25;

    public WaystoneSelectionScreenBase(WaystoneSelectionContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.waystones = container.getWaystones();
        this.field_146999_f = 270;
        this.field_147000_g = 200;
    }

    public void func_231160_c_() {
        int maxContentHeight = (int)((float)this.field_230709_l_ * 0.6f);
        int maxButtonsPerPage = (maxContentHeight - 40 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.waystones.size()));
        int contentHeight = 40 + this.buttonsPerPage * 25 + 25;
        this.field_146999_f = this.field_230708_k_;
        this.field_147000_g = contentHeight;
        super.func_231160_c_();
        this.tooltipProviders.clear();
        this.btnPrevPage = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 40, 95, 20, (ITextComponent)new TranslationTextComponent("gui.waystones.waystone_selection.previous_page"), button -> {
            this.pageOffset = Screen.func_231173_s_() ? 0 : this.pageOffset - 1;
            this.updateList();
        });
        this.func_230480_a_(this.btnPrevPage);
        this.btnNextPage = new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 2 + 40, 95, 20, (ITextComponent)new TranslationTextComponent("gui.waystones.waystone_selection.next_page"), button -> {
            this.pageOffset = Screen.func_231173_s_() ? (this.waystones.size() - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        });
        this.func_230480_a_(this.btnNextPage);
        this.updateList();
    }

    protected <T extends Widget> T func_230480_a_(T button) {
        if (button instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)button);
        }
        return (T)super.func_230480_a_(button);
    }

    private void updateList() {
        this.headerY = 0;
        this.btnPrevPage.field_230693_o_ = this.pageOffset > 0;
        this.btnNextPage.field_230693_o_ = this.pageOffset < (this.waystones.size() - 1) / this.buttonsPerPage;
        this.tooltipProviders.clear();
        this.field_230710_m_.removeIf(button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton);
        this.field_230705_e_.removeIf(button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton);
        int y = this.field_147009_r + 40 + this.headerY;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.waystones.size()) continue;
            IWaystone waystone = this.waystones.get(entryIndex);
            this.func_230480_a_(this.createWaystoneButton(y, waystone));
            if (this.allowSorting()) {
                SortWaystoneButton sortUpButton = new SortWaystoneButton(this.field_230708_k_ / 2 + 108, y + 2, -1, y, 20, it -> this.sortWaystone(entryIndex, -1));
                if (entryIndex == 0) {
                    sortUpButton.field_230693_o_ = false;
                }
                this.func_230480_a_(sortUpButton);
                SortWaystoneButton sortDownButton = new SortWaystoneButton(this.field_230708_k_ / 2 + 108, y + 13, 1, y, 20, it -> this.sortWaystone(entryIndex, 1));
                if (entryIndex == this.waystones.size() - 1) {
                    sortDownButton.field_230693_o_ = false;
                }
                this.func_230480_a_(sortDownButton);
            }
            if (this.allowDeletion()) {
                RemoveWaystoneButton removeButton = new RemoveWaystoneButton(this.field_230708_k_ / 2 + 122, y + 4, y, 20, waystone, button -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    PlayerWaystoneManager.deactivateWaystone((PlayerEntity)Objects.requireNonNull(player), waystone);
                    NetworkHandler.channel.sendToServer((Object)new RemoveWaystoneMessage(waystone));
                    this.updateList();
                });
                if (!waystone.isGlobal() || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                    this.func_230480_a_(removeButton);
                }
            }
            y += 22;
        }
        this.btnPrevPage.field_230691_m_ = this.field_147009_r + this.headerY + 40 + this.buttonsPerPage * 22 + (this.waystones.size() > 0 ? 10 : 0);
        this.btnNextPage.field_230691_m_ = this.field_147009_r + this.headerY + 40 + this.buttonsPerPage * 22 + (this.waystones.size() > 0 ? 10 : 0);
    }

    private WaystoneButton createWaystoneButton(int y, IWaystone waystone) {
        IWaystone waystoneFrom = ((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int xpLevelCost = Math.round(PlayerWaystoneManager.getExperienceLevelCost((Entity)Objects.requireNonNull(player), waystone, ((WaystoneSelectionContainer)this.field_147002_h).getWarpMode(), waystoneFrom));
        WaystoneButton btnWaystone = new WaystoneButton(this.field_230708_k_ / 2 - 100, y, waystone, xpLevelCost, button -> this.onWaystoneSelected(waystone));
        if (waystoneFrom != null && waystone.getWaystoneUid().equals(waystoneFrom.getWaystoneUid())) {
            btnWaystone.field_230693_o_ = false;
        }
        return btnWaystone;
    }

    protected void onWaystoneSelected(IWaystone waystone) {
        NetworkHandler.channel.sendToServer((Object)new SelectWaystoneMessage(waystone));
    }

    private void sortWaystone(int index, int sortDir) {
        int otherIndex;
        if (index < 0 || index >= this.waystones.size()) {
            return;
        }
        if (Screen.func_231173_s_()) {
            otherIndex = sortDir == -1 ? -1 : this.waystones.size();
        } else {
            otherIndex = index + sortDir;
            if (otherIndex < 0 || otherIndex >= this.waystones.size()) {
                return;
            }
        }
        PlayerWaystoneManager.swapWaystoneSorting((PlayerEntity)Minecraft.func_71410_x().field_71439_g, index, otherIndex);
        NetworkHandler.channel.sendToServer((Object)new SortWaystoneMessage(index, otherIndex));
        this.updateList();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.isLocationHeaderHovered && ((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom() != null) {
            NetworkHandler.channel.sendToServer((Object)new RequestEditWaystoneMessage(((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom()));
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            this.func_243308_b(matrixStack, tooltipProvider.getTooltip(), mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack p_230450_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IWaystone fromWaystone = ((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom();
        WaystoneSelectionScreenBase.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (ITextComponent)this.func_231171_q_(), (int)(this.field_146999_f / 2), (int)(this.headerY + (fromWaystone != null ? 20 : 0)), (int)0xFFFFFF);
        if (fromWaystone != null) {
            this.drawLocationHeader(matrixStack, fromWaystone, mouseX, mouseY, this.field_146999_f / 2, this.headerY);
        }
        if (this.waystones.size() == 0) {
            WaystoneSelectionScreenBase.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (String)(TextFormatting.RED + I18n.func_135052_a((String)"gui.waystones.waystone_selection.no_waystones_activated", (Object[])new Object[0])), (int)(this.field_146999_f / 2), (int)(this.field_147000_g / 2 - 20), (int)0xFFFFFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawLocationHeader(MatrixStack matrixStack, IWaystone waystone, int mouseX, int mouseY, int x, int y) {
        fontRenderer = Minecraft.func_71410_x().field_71466_p;
        locationPrefix = TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones.waystone_selection.current_location", (Object[])new Object[0]) + " ";
        locationPrefixWidth = fontRenderer.func_78256_a(locationPrefix);
        effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = I18n.func_135052_a((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        locationWidth = fontRenderer.func_78256_a(effectiveName);
        fullWidth = locationPrefixWidth + locationWidth;
        startX = x - fullWidth / 2 + locationPrefixWidth;
        startY = y + this.field_147009_r;
        if (mouseX < startX || mouseX >= startX + locationWidth + 16 || mouseY < startY) ** GOTO lbl-1000
        fontRenderer.getClass();
        if (mouseY < startY + 9) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isLocationHeaderHovered = v0;
        player = Minecraft.func_71410_x().field_71439_g;
        waystoneEditPermissions = PlayerWaystoneManager.mayEditWaystone((PlayerEntity)player, player.field_70170_p, waystone);
        fullText = locationPrefix + TextFormatting.WHITE;
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            fullText = fullText + TextFormatting.UNDERLINE;
        }
        fullText = fullText + effectiveName;
        WaystoneSelectionScreenBase.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (String)fullText, (int)(x - fullWidth / 2), (int)y, (int)0xFFFFFF);
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((float)x + (float)fullWidth / 2.0f + 4.0f), (double)y, (double)0.0);
            scale = 0.5f;
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().func_175599_af().func_180450_b(new ItemStack((IItemProvider)Items.field_151099_bA), 0, 0);
            RenderSystem.popMatrix();
        }
    }

    protected boolean allowSorting() {
        return true;
    }

    protected boolean allowDeletion() {
        return true;
    }
}

