/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class RemoveWaystoneButton
extends Button
implements ITooltipProvider {
    private static final ResourceLocation BEACON = new ResourceLocation("textures/gui/container/beacon.png");
    private final List<ITextComponent> tooltip;
    private final List<ITextComponent> activeTooltip;
    private final int visibleRegionStart;
    private final int visibleRegionHeight;
    private static boolean shiftGuard;

    public RemoveWaystoneButton(int x, int y, int visibleRegionStart, int visibleRegionHeight, IWaystone waystone, Button.IPressable pressable) {
        super(x, y, 13, 13, (ITextComponent)new StringTextComponent(""), pressable);
        this.visibleRegionStart = visibleRegionStart;
        this.visibleRegionHeight = visibleRegionHeight;
        this.tooltip = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.waystones.waystone_selection.hold_shift_to_delete")});
        this.activeTooltip = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.waystones.waystone_selection.click_to_delete")});
        if (waystone.isGlobal()) {
            TranslationTextComponent component = new TranslationTextComponent("gui.waystones.waystone_selection.deleting_global_for_all");
            component.func_240699_a_(TextFormatting.DARK_RED);
            this.tooltip.add((ITextComponent)component);
            this.activeTooltip.add((ITextComponent)component);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            shiftGuard = true;
            return true;
        }
        return false;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        boolean shiftDown = Screen.func_231173_s_();
        if (!shiftDown) {
            shiftGuard = false;
        }
        boolean bl = this.field_230693_o_ = !shiftGuard && shiftDown;
        if (mouseY >= this.visibleRegionStart && mouseY < this.visibleRegionStart + this.visibleRegionHeight) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BEACON);
            if (this.field_230692_n_ && this.field_230693_o_) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 114, 223, 13, 13);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean shouldShowTooltip() {
        return this.field_230692_n_;
    }

    @Override
    public List<ITextComponent> getTooltip() {
        return this.field_230693_o_ ? this.activeTooltip : this.tooltip;
    }
}

