/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.tileentity.ActiveGhastTrapTileEntity;

public class GhastTrapBlock
extends Block {
    public static final int ACTIVATE_EVENT = 0;
    public static final int DEACTIVATE_EVENT = 1;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public GhastTrapBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() && this.isInactiveTrapCharged(world, pos) && world.func_175640_z(pos)) {
            for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_186662_g(6.0))) {
                TFAdvancements.ACTIVATED_GHAST_TRAP.trigger(player);
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.func_184133_a(null, pos, TFSounds.JET_START, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_175641_c(pos, (Block)this, 0, 0);
        }
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int event, int payload) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te.func_145842_c(event, payload);
    }

    private boolean isInactiveTrapCharged(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof ActiveGhastTrapTileEntity && ((ActiveGhastTrapTileEntity)tileEntity).isCharged();
    }

    public void sparkle(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_200015_d((IBlockReader)worldIn, pos)) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)worldIn, pos)) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_200015_d((IBlockReader)worldIn, pos)) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_200015_d((IBlockReader)worldIn, pos)) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_200015_d((IBlockReader)worldIn, pos)) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_200015_d((IBlockReader)worldIn, pos)) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ActiveGhastTrapTileEntity();
    }
}

