/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;

public class HeadLayerFeatureRenderer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private Set<Item> hideHeadLayers = Sets.newHashSet((Object[])new Item[]{Items.field_196184_dx, Items.field_196186_dz, Items.field_196185_dy, Items.field_196151_dA, Items.field_196182_dv, Items.field_196183_dw});
    private static final Minecraft mc = Minecraft.func_71410_x();

    public HeadLayerFeatureRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int i, AbstractClientPlayerEntity player, float f, float g, float h, float j, float k, float l) {
        if (!player.func_152123_o() || player.func_82150_aj() || !SkinLayersModBase.config.enableHat) {
            return;
        }
        if (HeadLayerFeatureRenderer.mc.field_71439_g.func_70068_e((Entity)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        ItemStack itemStack = player.func_184582_a(EquipmentSlotType.HEAD);
        if (itemStack != null && this.hideHeadLayers.contains(itemStack.func_77973_b())) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (settings.getHeadLayers() == null && !this.setupModel(player, settings)) {
            return;
        }
        IVertexBuilder vertexConsumer = multiBufferSource.getBuffer(RenderType.func_228642_d_((ResourceLocation)player.func_110306_p()));
        int m = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        this.renderCustomHelmet(settings, player, poseStack, vertexConsumer, i, m);
    }

    private boolean setupModel(AbstractClientPlayerEntity abstractClientPlayerEntity, PlayerSettings settings) {
        if (!SkinUtil.hasCustomSkin(abstractClientPlayerEntity)) {
            return false;
        }
        NativeImage skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);
        settings.setupHeadLayers(SolidPixelWrapper.wrapBoxOptimized(skin, (PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)this.func_215332_c()), 8, 8, 8, 32, 0, false, 0.6f));
        skin.func_195711_f();
        return true;
    }

    public void renderCustomHelmet(PlayerSettings settings, AbstractClientPlayerEntity abstractClientPlayer, MatrixStack matrixStack, IVertexBuilder vertices, int light, int overlay) {
        if (settings.getHeadLayers() == null) {
            return;
        }
        if (!((PlayerModel)this.func_215332_c()).field_78116_c.field_78806_j || !abstractClientPlayer.func_175148_a(PlayerModelPart.HAT)) {
            return;
        }
        float voxelSize = SkinLayersModBase.config.headVoxelSize;
        matrixStack.func_227860_a_();
        ((PlayerModel)this.func_215332_c()).field_78116_c.func_228307_a_(matrixStack);
        matrixStack.func_227862_a_(voxelSize, voxelSize, voxelSize);
        boolean red = abstractClientPlayer.field_70737_aN > 0 || abstractClientPlayer.field_70725_aQ > 0;
        float color = red ? 0.5f : 1.0f;
        settings.getHeadLayers().render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
        matrixStack.func_227865_b_();
    }
}

