/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.renderer;

import artifacts.client.render.curio.model.HandsModel;
import artifacts.client.render.curio.renderer.CurioRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class GloveCurioRenderer
implements CurioRenderer {
    private final ResourceLocation defaultTexture;
    private final ResourceLocation slimTexture;
    private final HandsModel defaultModel;
    private final HandsModel slimModel;

    public GloveCurioRenderer(String name) {
        this(String.format("glove/%s/%s_default", name, name), String.format("glove/%s/%s_slim", name, name), HandsModel::glove);
    }

    public GloveCurioRenderer(String name, Function<Boolean, HandsModel> modelFactory) {
        this(String.format("%s/%s_default", name, name), String.format("%s/%s_slim", name, name), modelFactory);
    }

    public GloveCurioRenderer(String defaultTexturePath, String slimTexturePath, Function<Boolean, HandsModel> modelFactory) {
        this.defaultTexture = new ResourceLocation("artifacts", String.format("textures/entity/curio/%s.png", defaultTexturePath));
        this.slimTexture = new ResourceLocation("artifacts", String.format("textures/entity/curio/%s.png", slimTexturePath));
        this.defaultModel = modelFactory.apply(false);
        this.slimModel = modelFactory.apply(true);
    }

    protected ResourceLocation getTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimTexture : this.defaultTexture;
    }

    protected HandsModel getModel(boolean hasSlimArms) {
        return hasSlimArms ? this.slimModel : this.defaultModel;
    }

    protected static boolean hasSlimArms(Entity entity) {
        return entity instanceof AbstractClientPlayerEntity && ((AbstractClientPlayerEntity)entity).func_175154_l().equals("slim");
    }

    @Override
    public final void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ticks, float headYaw, float headPitch, ItemStack stack) {
        boolean hasSlimArms = GloveCurioRenderer.hasSlimArms((Entity)entity);
        HandsModel model = this.getModel(hasSlimArms);
        Hand hand = index % 2 == 0 ? Hand.MAIN_HAND : Hand.OFF_HAND;
        HandSide handSide = hand == Hand.MAIN_HAND ? entity.func_184591_cq() : entity.func_184591_cq().func_188468_a();
        model.func_225597_a_(entity, limbSwing, limbSwingAmount, ticks, headYaw, headPitch);
        model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
        this.renderArm(model, matrixStack, buffer, handSide, light, hasSlimArms, stack.func_77962_s());
    }

    protected void renderArm(HandsModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, HandSide handSide, int light, boolean hasSlimArms, boolean hasFoil) {
        RenderType renderType = model.func_228282_a_(this.getTexture(hasSlimArms));
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        model.renderHand(handSide, matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public final void renderFirstPersonArm(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, AbstractClientPlayerEntity player, HandSide side, boolean hasFoil) {
        if (!player.func_175149_v()) {
            boolean hasSlimArms = GloveCurioRenderer.hasSlimArms((Entity)player);
            HandsModel model = this.getModel(hasSlimArms);
            ModelRenderer arm = side == HandSide.LEFT ? model.field_178724_i : model.field_178723_h;
            model.func_178719_a(false);
            arm.field_78806_j = true;
            model.field_228270_o_ = false;
            model.field_205061_a = 0.0f;
            model.field_217112_c = 0.0f;
            model.func_225597_a_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.field_78795_f = 0.0f;
            this.renderFirstPersonArm(model, arm, matrixStack, buffer, light, hasSlimArms, hasFoil);
        }
    }

    protected void renderFirstPersonArm(HandsModel model, ModelRenderer arm, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, boolean hasSlimArms, boolean hasFoil) {
        RenderType renderType = model.func_228282_a_(this.getTexture(hasSlimArms));
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        arm.func_228308_a_(matrixStack, builder, light, OverlayTexture.field_229196_a_);
    }
}

