/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.capability.swimhandler.ISwimHandler;
import artifacts.common.capability.swimhandler.SwimHandlerCapability;
import artifacts.common.config.ModConfig;
import artifacts.common.item.ArtifactItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class UmbrellaItem
extends ArtifactItem {
    public static final AttributeModifier UMBRELLA_SLOW_FALLING = new AttributeModifier(UUID.fromString("a7a25453-2065-4a96-bc83-df600e13f390"), "artifacts:umbrella_slow_falling", -0.875, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public UmbrellaItem() {
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    private void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity;
        ModifiableAttributeInstance gravity;
        if (!ModConfig.server.isCosmetic(this) && (gravity = (entity = event.getEntityLiving()).func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get())) != null) {
            boolean isInWater;
            boolean bl = isInWater = entity.func_70090_H() && entity.getCapability(SwimHandlerCapability.INSTANCE).map(ISwimHandler::isSinking).orElse(false) == false;
            if (!(entity.func_233570_aj_() || isInWater || !(event.getEntity().func_213322_ci().field_72448_b < 0.0) || entity.func_70644_a(Effects.field_204839_B) || entity.func_184592_cb().func_77973_b() != this && entity.func_184614_ca().func_77973_b() != this || entity.func_184587_cr() && !entity.func_184607_cu().func_190926_b() && entity.func_184607_cu().func_77973_b().func_77661_b(entity.func_184607_cu()) == UseAction.BLOCK)) {
                if (!gravity.func_180374_a(UMBRELLA_SLOW_FALLING)) {
                    gravity.func_233767_b_(UMBRELLA_SLOW_FALLING);
                }
                entity.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(UMBRELLA_SLOW_FALLING)) {
                gravity.func_111124_b(UMBRELLA_SLOW_FALLING);
            }
        }
    }

    public boolean isShield(@Nullable ItemStack stack, @Nullable LivingEntity entity) {
        return !ModConfig.server.isCosmetic(this) && (Boolean)ModConfig.server.umbrella.isShield.get() != false;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!this.isShield(null, null)) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity, Hand hand) {
        return entity.func_184586_b(hand).func_77973_b() instanceof UmbrellaItem && (!entity.func_184587_cr() || entity.func_184600_cs() != hand);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity) {
        return UmbrellaItem.isHoldingUmbrellaUpright(entity, Hand.MAIN_HAND) || UmbrellaItem.isHoldingUmbrellaUpright(entity, Hand.OFF_HAND);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="artifacts")
    public static class ClientEvents {
        @SubscribeEvent
        public static void onLivingRender(RenderLivingEvent.Pre<?, ?> event) {
            boolean isRightHanded;
            if (!(event.getRenderer().func_217764_d() instanceof BipedModel)) {
                return;
            }
            LivingEntity entity = event.getEntity();
            BipedModel model = (BipedModel)event.getRenderer().func_217764_d();
            boolean isHoldingOffHand = UmbrellaItem.isHoldingUmbrellaUpright(entity, Hand.OFF_HAND);
            boolean isHoldingMainHand = UmbrellaItem.isHoldingUmbrellaUpright(entity, Hand.MAIN_HAND);
            boolean bl = isRightHanded = entity.func_184591_cq() == HandSide.RIGHT;
            if (isHoldingMainHand && isRightHanded || isHoldingOffHand && !isRightHanded) {
                model.field_187076_m = BipedModel.ArmPose.THROW_SPEAR;
            }
            if (isHoldingMainHand && !isRightHanded || isHoldingOffHand && isRightHanded) {
                model.field_187075_l = BipedModel.ArmPose.THROW_SPEAR;
            }
        }
    }
}

