/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.necklace;

import artifacts.common.capability.swimhandler.SwimHandlerCapability;
import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.SlotContext;

public class CharmOfSinkingItem
extends CurioItem {
    public CharmOfSinkingItem() {
        this.addListener(EventPriority.HIGH, PlayerEvent.BreakSpeed.class, this::onBreakSpeed);
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 == 0 && livingEntity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.damageStack(identifier, index, livingEntity, stack);
        }
    }

    public void onBreakSpeed(PlayerEvent.BreakSpeed event, LivingEntity wearer) {
        if (wearer.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)wearer)) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        if (!ModConfig.server.isCosmetic(this) && slotContext.getWearer() instanceof ServerPlayerEntity) {
            slotContext.getWearer().getCapability(SwimHandlerCapability.INSTANCE).ifPresent(handler -> {
                handler.setSinking(true);
                handler.syncSinking((ServerPlayerEntity)slotContext.getWearer());
            });
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        if (slotContext.getWearer() instanceof ServerPlayerEntity) {
            slotContext.getWearer().getCapability(SwimHandlerCapability.INSTANCE).ifPresent(handler -> {
                handler.setSinking(false);
                handler.syncSinking((ServerPlayerEntity)slotContext.getWearer());
            });
        }
    }
}

