/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.network;

import artifacts.common.capability.swimhandler.SwimHandlerCapability;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SwimPacket {
    private final boolean shouldSwim;

    public SwimPacket(PacketBuffer buffer) {
        this.shouldSwim = buffer.readBoolean();
    }

    public SwimPacket(boolean shouldSwim) {
        this.shouldSwim = shouldSwim;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.shouldSwim);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        if (player != null) {
            context.get().enqueueWork(() -> this.lambda$handle$1((PlayerEntity)player));
        }
        context.get().setPacketHandled(true);
    }

    private /* synthetic */ void lambda$handle$1(PlayerEntity player) {
        player.getCapability(SwimHandlerCapability.INSTANCE).ifPresent(handler -> handler.setSwimming(this.shouldSwim));
    }
}

