/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.bayou_blues.core.registry;

import com.minecraftabnormals.abnormals_core.core.util.BiomeUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.BiomeSubRegistryHelper;
import com.mojang.datafixers.util.Pair;
import com.teamaurora.bayou_blues.core.BayouBlues;
import com.teamaurora.bayou_blues.core.BayouBluesConfig;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bayou_blues", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BayouBluesBiomes {
    private static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)BayouBlues.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome BAYOU = HELPER.createBiome("bayou", () -> BayouBluesBiomes.makeBayouBiome(-0.175f, 0.2f));
    public static final BiomeSubRegistryHelper.KeyedBiome BAYOU_HILLS = HELPER.createBiome("bayou_hills", () -> BayouBluesBiomes.makeBayouBiome(-0.1f, 0.4f));

    public static void addHillBiome() {
        BiomeUtil.addHillBiome((RegistryKey)BAYOU.getKey(), (Pair[])new Pair[]{Pair.of((Object)BAYOU_HILLS.getKey(), (Object)1)});
    }

    public static void registerBiomesToDictionary() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BAYOU.getKey(), ((Integer)BayouBluesConfig.COMMON.bayouWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BAYOU_HILLS.getKey(), ((Integer)BayouBluesConfig.COMMON.bayouHillsWeight.get()).intValue()));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((RegistryKey)BAYOU.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((RegistryKey)BAYOU_HILLS.getKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD});
    }

    private static Biome makeBayouBiome(float depth, float scale) {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.75f).func_205417_d(1.0f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(8896710).func_235248_c_(4018518).func_235239_a_(10543845).func_242539_d(BayouBluesBiomes.getSkyColorWithTemperatureModifier(0.75f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_242540_e(6924847).func_242541_f(7127367).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244189_u).func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float f = temperature / 3.0f;
        f = MathHelper.func_76131_a((float)f, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }
}

