/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.ravine;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CanyonWorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class RavineCarver
extends CanyonWorldCarver {
    private ISeedReader world;
    private boolean isFloodedRavinesEnabled;
    private boolean isReplaceGravelEnabled;
    private int liquidAltitude;
    private final float[] heightToHorizontalStretchFactor = new float[1024];

    public RavineCarver(ISeedReader worldIn, ConfigHolder config, Codec<ProbabilityConfig> codec) {
        super(codec);
        this.world = worldIn;
        this.isFloodedRavinesEnabled = config.enableFloodedRavines.get();
        this.isReplaceGravelEnabled = config.replaceFloatingGravel.get();
        this.liquidAltitude = config.liquidAltitude.get();
    }

    public void carve(IChunk chunkIn, Random rand, int seaLevel, int chunkX, int chunkZ, int originChunkX, int originChunkZ, BlockState[][] liquidBlocks, Function<BlockPos, Biome> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double startX = chunkX * 16 + rand.nextInt(16);
        double startY = rand.nextInt(rand.nextInt(40) + 8) + 20;
        double startZ = chunkZ * 16 + rand.nextInt(16);
        float yaw = rand.nextFloat() * ((float)Math.PI * 2);
        float pitch = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float width = (rand.nextFloat() * 2.0f + rand.nextFloat()) * 2.0f;
        double heightModifier = 3.0;
        int startCounter = 0;
        int endCounter = i - rand.nextInt(i / 4);
        this.carveRavine(chunkIn, rand.nextLong(), seaLevel, originChunkX, originChunkZ, startX, startY, startZ, width, yaw, pitch, startCounter, endCounter, heightModifier, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
    }

    private void carveRavine(IChunk chunkIn, long seed, int seaLevel, int originChunkX, int originChunkZ, double ravineStartX, double ravineStartY, double ravineStartZ, float width, float yaw, float pitch, int startCounter, int endCounter, double heightModifier, BlockState[][] liquidBlocks, Function<BlockPos, Biome> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        Random random = new Random(seed);
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.heightToHorizontalStretchFactor[i] = f * f;
        }
        float yawModifier = 0.0f;
        float pitchModifier = 0.0f;
        while (startCounter < endCounter) {
            double xzOffset = 1.5 + (double)(MathHelper.func_76126_a((float)((float)startCounter * (float)Math.PI / (float)endCounter)) * width);
            double yOffset = xzOffset * heightModifier;
            xzOffset *= (double)random.nextFloat() * 0.25 + 0.75;
            yOffset *= (double)random.nextFloat() * 0.25 + 0.75;
            float pitchXZ = MathHelper.func_76134_b((float)pitch);
            float pitchY = MathHelper.func_76126_a((float)pitch);
            ravineStartX += (double)(MathHelper.func_76134_b((float)yaw) * pitchXZ);
            ravineStartY += (double)pitchY;
            ravineStartZ += (double)(MathHelper.func_76126_a((float)yaw) * pitchXZ);
            pitch *= 0.7f;
            pitch += pitchModifier * 0.05f;
            yaw += yawModifier * 0.05f;
            pitchModifier *= 0.8f;
            yawModifier *= 0.5f;
            pitchModifier += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            yawModifier += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) != 0) {
                if (!this.canCarveBranch(originChunkX, originChunkZ, ravineStartX, ravineStartZ, startCounter, endCounter, width)) {
                    return;
                }
                this.carveRegion(chunkIn, seed, seaLevel, originChunkX, originChunkZ, ravineStartX, ravineStartY, ravineStartZ, xzOffset, yOffset, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
            }
            ++startCounter;
        }
    }

    protected boolean canCarveBranch(int originChunkX, int originChunkZ, double ravineStartX, double ravineStartZ, int startCounter, int endCounter, float width) {
        double originBlockX = originChunkX * 16 + 8;
        double ravineStartXOffsetFromCenter = ravineStartX - originBlockX;
        double originBlockZ = originChunkZ * 16 + 8;
        double ravineStartZOffsetFromCenter = ravineStartZ - originBlockZ;
        double distanceToEnd = endCounter - startCounter;
        double d5 = width + 2.0f + 16.0f;
        return ravineStartXOffsetFromCenter * ravineStartXOffsetFromCenter + ravineStartZOffsetFromCenter * ravineStartZOffsetFromCenter - distanceToEnd * distanceToEnd <= d5 * d5;
    }

    protected void carveRegion(IChunk chunkIn, long seed, int seaLevel, int originChunkX, int originChunkZ, double ravineStartX, double ravineStartY, double ravineStartZ, double xzOffset, double yOffset, BlockState[][] liquidBlocks, Function<BlockPos, Biome> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        Random rand = new Random(seed + (long)originChunkX + (long)originChunkZ);
        double originBlockX = originChunkX * 16 + 8;
        double originBlockZ = originChunkZ * 16 + 8;
        if (!(ravineStartX < originBlockX - 16.0 - xzOffset * 2.0 || ravineStartZ < originBlockZ - 16.0 - xzOffset * 2.0 || ravineStartX > originBlockX + 16.0 + xzOffset * 2.0 || ravineStartZ > originBlockZ + 16.0 + xzOffset * 2.0)) {
            int minLocalX = Math.max(MathHelper.func_76128_c((double)(ravineStartX - xzOffset)) - originChunkX * 16 - 1, 0);
            int maxLocalX = Math.min(MathHelper.func_76128_c((double)(ravineStartX + xzOffset)) - originChunkX * 16 + 1, 16);
            int minY = Math.max(MathHelper.func_76128_c((double)(ravineStartY - yOffset)) - 1, 1);
            int maxY = Math.min(MathHelper.func_76128_c((double)(ravineStartY + yOffset)) + 1, this.field_222720_l - 8);
            int minLocalZ = Math.max(MathHelper.func_76128_c((double)(ravineStartZ - xzOffset)) - originChunkZ * 16 - 1, 0);
            int maxLocalZ = Math.min(MathHelper.func_76128_c((double)(ravineStartZ + xzOffset)) - originChunkZ * 16 + 1, 16);
            BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
            for (int currLocalX = minLocalX; currLocalX < maxLocalX; ++currLocalX) {
                int realX = currLocalX + originChunkX * 16;
                double xAxisDist = ((double)realX + 0.5 - ravineStartX) / xzOffset;
                for (int currLocalZ = minLocalZ; currLocalZ < maxLocalZ; ++currLocalZ) {
                    int realZ = currLocalZ + originChunkZ * 16;
                    double zAxisDist = ((double)realZ + 0.5 - ravineStartZ) / xzOffset;
                    if (xAxisDist * xAxisDist + zAxisDist * zAxisDist >= 1.0) continue;
                    for (int currY = maxY; currY > minY; --currY) {
                        double yAxisDist = ((double)currY - 0.5 - ravineStartY) / yOffset;
                        if (this.isPositionExcluded(xAxisDist, yAxisDist, zAxisDist, currY)) continue;
                        mutableBlockPos.func_181079_c(realX, currY, realZ);
                        BlockState liquidBlock = liquidBlocks[currLocalX][currLocalZ];
                        if (currY <= this.liquidAltitude && liquidBlock == null) {
                            return;
                        }
                        this.carveBlock(chunkIn, rand, seaLevel, mutableBlockPos, liquidBlock, biomePos, airCarvingMask, liquidCarvingMask);
                    }
                }
            }
        }
    }

    private boolean isPositionExcluded(double xAxisDist, double yAxisDist, double zAxisDist, int currY) {
        return (xAxisDist * xAxisDist + zAxisDist * zAxisDist) * (double)this.heightToHorizontalStretchFactor[currY - 1] + yAxisDist * yAxisDist / 6.0 >= 1.0;
    }

    private void carveBlock(IChunk chunkIn, Random rand, int seaLevel, BlockPos.Mutable blockPos, BlockState liquidBlockState, Function<BlockPos, Biome> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        boolean flooded;
        int bitIndex = blockPos.func_177958_n() & 0xF | (blockPos.func_177952_p() & 0xF) << 4 | blockPos.func_177956_o() << 8;
        if (airCarvingMask.get(bitIndex) || liquidCarvingMask.get(bitIndex)) {
            return;
        }
        boolean bl = flooded = this.isFloodedRavinesEnabled && biomePos.apply((BlockPos)blockPos).func_201856_r() == Biome.Category.OCEAN;
        if (flooded && blockPos.func_177956_o() >= seaLevel) {
            return;
        }
        float smoothAmpFloodFactor = BetterCavesUtils.getDistFactor((IWorld)this.world, biomePos, (BlockPos)blockPos, 2, flooded ? BetterCavesUtils.isNotOcean : BetterCavesUtils.isOcean);
        if (smoothAmpFloodFactor <= 0.25f) {
            return;
        }
        if (flooded) {
            CarverUtils.carveFloodedBlock(chunkIn, rand, blockPos, liquidBlockState, this.liquidAltitude, liquidCarvingMask);
        } else {
            CarverUtils.carveBlock(chunkIn, (BlockPos)blockPos, liquidBlockState, this.liquidAltitude, this.isReplaceGravelEnabled, airCarvingMask);
        }
    }

    public void setWorld(ISeedReader worldIn) {
        this.world = worldIn;
    }
}

