/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.altar;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.altar.AltarComponent;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.AltarUpgrade;
import wayoftime.bloodmagic.altar.ComponentType;
import wayoftime.bloodmagic.common.block.BlockBloodRune;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.tile.TileAltar;

public class AltarUtil {
    @Nonnull
    public static AltarTier getTier(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileAltar)) {
            return AltarTier.ONE;
        }
        AltarTier lastCheck = AltarTier.ONE;
        for (AltarTier tier : AltarTier.values()) {
            for (AltarComponent component : tier.getAltarComponents()) {
                List<BlockState> validStates;
                BlockPos componentPos = pos.func_177971_a((Vector3i)component.getOffset());
                BlockState worldState = world.func_180495_p(componentPos);
                if (component.getComponent() == ComponentType.NOTAIR && worldState.func_185904_a() != Material.field_151579_a && !worldState.func_185904_a().func_76224_d() || (validStates = BloodMagicAPI.INSTANCE.getComponentStates(component.getComponent())).contains(worldState)) continue;
                return lastCheck;
            }
            lastCheck = tier;
        }
        return lastCheck;
    }

    @Nonnull
    public static AltarUpgrade getUpgrades(World world, BlockPos pos, AltarTier currentTier) {
        AltarUpgrade upgrades = new AltarUpgrade();
        for (AltarComponent component : currentTier.getAltarComponents()) {
            BlockPos componentPos;
            BlockState state;
            if (!component.isUpgradeSlot() || component.getComponent() != ComponentType.BLOODRUNE || !((state = world.func_180495_p(componentPos = pos.func_177971_a((Vector3i)component.getOffset()))).func_177230_c() instanceof BlockBloodRune)) continue;
            upgrades.upgrade(((BlockBloodRune)state.func_177230_c()).getBloodRune(world, componentPos));
        }
        return upgrades;
    }

    @Nullable
    public static Pair<BlockPos, ComponentType> getFirstMissingComponent(World world, BlockPos pos, int altarTier) {
        if (altarTier >= AltarTier.MAXTIERS) {
            return null;
        }
        for (AltarTier tier : AltarTier.values()) {
            for (AltarComponent component : tier.getAltarComponents()) {
                List<BlockState> validStates;
                BlockPos componentPos = pos.func_177971_a((Vector3i)component.getOffset());
                BlockState worldState = world.func_180495_p(componentPos);
                if (component.getComponent() == ComponentType.NOTAIR && worldState.func_185904_a() != Material.field_151579_a && !worldState.func_185904_a().func_76224_d() || (validStates = BloodMagicAPI.INSTANCE.getComponentStates(component.getComponent())).contains(worldState)) continue;
                return Pair.of((Object)componentPos, (Object)((Object)component.getComponent()));
            }
        }
        return null;
    }
}

