/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.network.AlchemyTableButtonPacket;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.tile.TileAlchemyTable;
import wayoftime.bloodmagic.tile.container.ContainerAlchemyTable;

public class ScreenAlchemyTable
extends ScreenBase<ContainerAlchemyTable> {
    private static final ResourceLocation background = new ResourceLocation("bloodmagic", "textures/gui/alchemytable.png");
    private static final List<ITextComponent> orbError = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> lpError = new ArrayList<ITextComponent>();
    public TileAlchemyTable tileTable;
    private int left;
    private int top;

    public ScreenAlchemyTable(ContainerAlchemyTable container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.tileTable = container.tileTable;
        this.field_146999_f = 176;
        this.field_147000_g = 205;
        orbError.clear();
        orbError.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.alchemytable.orberror.title").func_240699_a_(TextFormatting.RED));
        orbError.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.alchemytable.orberror.text").func_240699_a_(TextFormatting.GRAY));
        lpError.clear();
        lpError.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.alchemytable.lperror.title").func_240699_a_(TextFormatting.RED));
        lpError.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.alchemytable.lperror.text").func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("tile.bloodmagic.alchemytable.name"), 8.0f, 5.0f, 0x404040);
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("container.inventory"), 8.0f, 111.0f, 0x404040);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.left = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.top = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)new Button(this.left + 135, this.top + 52, 14, 14, (ITextComponent)new StringTextComponent("D"), (Button.IPressable)new DirectionalPress(this.tileTable, Direction.DOWN)));
        this.func_230480_a_((Widget)new Button(this.left + 153, this.top + 52, 14, 14, (ITextComponent)new StringTextComponent("U"), (Button.IPressable)new DirectionalPress(this.tileTable, Direction.UP)));
        this.func_230480_a_((Widget)new Button(this.left + 135, this.top + 70, 14, 14, (ITextComponent)new StringTextComponent("N"), (Button.IPressable)new DirectionalPress(this.tileTable, Direction.NORTH)));
        this.func_230480_a_((Widget)new Button(this.left + 153, this.top + 70, 14, 14, (ITextComponent)new StringTextComponent("S"), (Button.IPressable)new DirectionalPress(this.tileTable, Direction.SOUTH)));
        this.func_230480_a_((Widget)new Button(this.left + 135, this.top + 88, 14, 14, (ITextComponent)new StringTextComponent("W"), (Button.IPressable)new DirectionalPress(this.tileTable, Direction.WEST)));
        this.func_230480_a_((Widget)new Button(this.left + 153, this.top + 88, 14, 14, (ITextComponent)new StringTextComponent("E"), (Button.IPressable)new DirectionalPress(this.tileTable, Direction.EAST)));
    }

    @Override
    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        int slotId;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(background);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = this.getCookProgressScaled(90);
        this.func_238474_b_(stack, i + 106, j + 14 + 90 - l, 176, 90 - l, 18, l);
        if (this.getOrbFlag()) {
            this.func_238474_b_(stack, i + 106, j + 24, 194, 55, 18, 18);
            if (mouseX >= i + 106 && mouseX < i + 106 + 18 && mouseY >= j + 24 && mouseY < j + 24 + 18) {
                this.renderWrappedToolTip(stack, orbError, mouseX, mouseY, this.field_230712_o_);
            }
        } else if (this.getLPFlag()) {
            this.func_238474_b_(stack, i + 106, j + 24, 194, 73, 18, 18);
            if (mouseX >= i + 106 && mouseX < i + 106 + 18 && mouseY >= j + 24 && mouseY < j + 24 + 18) {
                this.renderWrappedToolTip(stack, lpError, mouseX, mouseY, this.field_230712_o_);
            }
        }
        if ((slotId = this.tileTable.activeSlot) != -1) {
            Slot slot = ((ContainerAlchemyTable)this.func_212873_a_()).func_75139_a(slotId);
            if (slotId == 7) {
                this.func_238474_b_(stack, i + slot.field_75223_e, j + slot.field_75221_f, 195, 37, 16, 16);
            } else {
                this.func_238474_b_(stack, i + slot.field_75223_e, j + slot.field_75221_f, 195, 19, 16, 16);
            }
            for (int buttonId = 0; buttonId < 6; ++buttonId) {
                int xOffset = buttonId % 2 * 18 + 133;
                int yOffset = buttonId / 2 * 18 + 50;
                if (this.tileTable.isSlotEnabled(slotId, Direction.func_82600_a((int)buttonId))) {
                    this.func_238474_b_(stack, i + xOffset, j + yOffset, 212, 18, 18, 18);
                    continue;
                }
                this.func_238474_b_(stack, i + xOffset, j + yOffset, 212, 0, 18, 18);
            }
        }
    }

    public int getCookProgressScaled(int scale) {
        double progress = this.tileTable.getProgressForGui();
        return (int)(progress * (double)scale);
    }

    public boolean getOrbFlag() {
        return this.tileTable.getOrbFlagForGui();
    }

    public boolean getLPFlag() {
        return this.tileTable.getLPFlagforGui();
    }

    public class DirectionalPress
    implements Button.IPressable {
        private final TileAlchemyTable table;
        private final Direction direction;

        public DirectionalPress(TileAlchemyTable table, Direction direction) {
            this.table = table;
            this.direction = direction;
        }

        public void onPress(Button button) {
            int activeSlot = this.table.activeSlot;
            if (activeSlot != -1) {
                boolean enabled = this.table.isSlotEnabled(activeSlot, this.direction);
                this.table.setSlotEnabled(!enabled, activeSlot, this.direction);
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new AlchemyTableButtonPacket(this.table.func_174877_v(), activeSlot, this.direction, !enabled));
            }
        }
    }

    public class DirectionalButton
    extends Button {
        private static final int BUTTON_TEX_X = 200;
        private static final int BUTTON_TEX_Y = 60;

        public DirectionalButton(int x, int y, int width, int height, ITextComponent title, Button.IPressable pressedAction) {
            super(x, y, width, height, title, pressedAction);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(field_230687_i_);
            int i = this.func_230989_a_(this.func_230449_g_());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int width = this.field_230688_j_;
            int height = this.field_230689_k_;
            int halfWidthLeft = width / 2;
            int halfWidthRight = width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
            int halfHeightTop = height / 2;
            int halfHeightBottom = height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
            int position = i * 20;
            DirectionalButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)position, (int)halfWidthLeft, (int)halfHeightTop, (int)200, (int)60);
            DirectionalButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + halfHeightTop), (float)0.0f, (float)(position + 20 - halfHeightBottom), (int)halfWidthLeft, (int)halfHeightBottom, (int)200, (int)60);
            DirectionalButton.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + halfWidthLeft), (int)this.field_230691_m_, (float)(200 - halfWidthRight), (float)position, (int)halfWidthRight, (int)halfHeightTop, (int)200, (int)60);
            DirectionalButton.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + halfWidthLeft), (int)(this.field_230691_m_ + halfHeightTop), (float)(200 - halfWidthRight), (float)(position + 20 - halfHeightBottom), (int)halfWidthRight, (int)halfHeightBottom, (int)200, (int)60);
            this.func_230441_a_(matrixStack, minecraft, mouseX, mouseY);
            RenderSystem.disableBlend();
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }
    }
}

