/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class ARCRecipeBuilder
extends BloodMagicRecipeBuilder<ARCRecipeBuilder> {
    private final Ingredient input;
    private final Ingredient arcTool;
    private final FluidStackIngredient inputFluid;
    private final ItemStack output;
    private final FluidStack outputFluid;
    private final List<Pair<ItemStack, Double>> addedItems = new ArrayList<Pair<ItemStack, Double>>();
    private final boolean consumeIngredient;

    protected ARCRecipeBuilder(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid, boolean consumeIngredient) {
        super(ARCRecipeBuilder.bmSerializer("arc"));
        this.input = input;
        this.arcTool = arcTool;
        this.inputFluid = inputFluid;
        this.output = output;
        this.outputFluid = outputFluid == null ? FluidStack.EMPTY : outputFluid;
        this.consumeIngredient = consumeIngredient;
    }

    public static ARCRecipeBuilder arc(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid) {
        return new ARCRecipeBuilder(input, arcTool, inputFluid, output, outputFluid, false);
    }

    public static ARCRecipeBuilder arcConsume(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid) {
        return new ARCRecipeBuilder(input, arcTool, inputFluid, output, outputFluid, true);
    }

    public ARCRecipeBuilder addRandomOutput(ItemStack stack, double chance) {
        if (this.addedItems.size() >= 3) {
            return this;
        }
        this.addedItems.add((Pair<ItemStack, Double>)Pair.of((Object)stack, (Object)chance));
        return this;
    }

    @Override
    protected ARCRecipeResult getResult(ResourceLocation id) {
        return new ARCRecipeResult(id);
    }

    public class ARCRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected ARCRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("input", ARCRecipeBuilder.this.input.func_200304_c());
            json.add("tool", ARCRecipeBuilder.this.arcTool.func_200304_c());
            if (ARCRecipeBuilder.this.inputFluid != null) {
                json.add("inputFluid", ARCRecipeBuilder.this.inputFluid.serialize());
            }
            if (ARCRecipeBuilder.this.addedItems.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Pair pair : ARCRecipeBuilder.this.addedItems) {
                    JsonObject jsonObj = new JsonObject();
                    jsonObj.addProperty("chance", (Number)Float.valueOf(((Double)pair.getValue()).floatValue()));
                    jsonObj.add("type", SerializerHelper.serializeItemStack((ItemStack)pair.getKey()));
                    mainArray.add((JsonElement)jsonObj);
                }
                json.add("addedoutput", (JsonElement)mainArray);
            }
            if (ARCRecipeBuilder.this.outputFluid != null && !ARCRecipeBuilder.this.outputFluid.isEmpty()) {
                json.add("outputFluid", SerializerHelper.serializeFluidStack(ARCRecipeBuilder.this.outputFluid));
            }
            json.add("output", SerializerHelper.serializeItemStack(ARCRecipeBuilder.this.output));
            json.addProperty("consumeingredient", Boolean.valueOf(ARCRecipeBuilder.this.consumeIngredient));
        }
    }
}

