/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.item.inventory.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.CollectionEnchantFilterKey;
import wayoftime.bloodmagic.common.item.routing.EnchantFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.item.routing.NoEnchantsFilterKey;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemEnchantFilterCore
extends ItemRouterFilter
implements INestableItemFilterProvider {
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack filterStack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.enchantfilter.desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        if (filterStack.func_77978_p() == null) {
            return;
        }
        boolean sneaking = Screen.func_231173_s_();
        if (!sneaking) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.extraInfo").func_240699_a_(TextFormatting.BLUE));
        } else {
            boolean isWhitelist;
            int whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
            boolean bl = isWhitelist = whitelistState == 0;
            if (isWhitelist) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.whitelist").func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.blacklist").func_240699_a_(TextFormatting.GRAY));
            }
            InventoryFilter inv = new InventoryFilter(filterStack);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                List<ITextComponent> list = this.getTextForHoverItem(filterStack, "enchant", i);
                List<ITextComponent> fuzzyList = this.getTextForHoverItem(filterStack, "enchant_lvl", i);
                if (list.size() <= 0 || fuzzyList.size() <= 0) continue;
                TranslationTextComponent fuzzyText = new TranslationTextComponent("tooltip.bloodmagic.filter.enchant_combination", new Object[]{fuzzyList.get(0), list.get(0)});
                if (isWhitelist) {
                    int amount = GhostItemHelper.getItemGhostAmount(stack);
                    if (amount > 0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, fuzzyText}));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.all", new Object[]{fuzzyText}));
                    }
                } else {
                    tooltip.add((ITextComponent)fuzzyText);
                }
                for (int j = 1; j < list.size(); ++j) {
                    tooltip.add(list.get(j));
                }
            }
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        int index = this.getEnchantmentIndex(filterStack, slot);
        boolean isFuzzy = this.getIsFuzzy(filterStack, slot);
        if (index == 0 || index == 1) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)ghostStack);
            if (enchants.size() <= 0) {
                return new NoEnchantsFilterKey(amount);
            }
            boolean matchAll = index == 1;
            return new CollectionEnchantFilterKey(enchants, isFuzzy, matchAll, amount);
        }
        Pair<Enchantment, Integer> enchant = this.getEnchantment(filterStack, slot);
        if (enchant != null) {
            return new EnchantFilterKey((Enchantment)enchant.getKey(), (Integer)enchant.getRight(), isFuzzy, amount);
        }
        return new NoEnchantsFilterKey(amount);
    }

    public int getEnchantmentIndex(ItemStack filterStack, int slot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            filterStack.func_77982_d(tag);
        }
        return tag.func_74762_e("button:enchant" + slot);
    }

    public void setEnchantmentIndex(ItemStack filterStack, int slot, int index) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            filterStack.func_77982_d(tag);
        }
        tag.func_74768_a("button:enchant" + slot, index);
    }

    public void cycleToNextEnchant(ItemStack filterStack, int slot) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.func_70301_a(slot);
        if (ghostStack.func_190926_b()) {
            return;
        }
        int index = this.getEnchantmentIndex(filterStack, slot);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)ghostStack);
        if (++index >= enchants.size() + 2 || enchants.size() == 0) {
            index = 0;
        }
        if (enchants.size() == 1 && index == 1) {
            index = 2;
        }
        this.setEnchantmentIndex(filterStack, slot, index);
    }

    public Pair<Enchantment, Integer> getEnchantment(ItemStack filterStack, int slot) {
        int index = this.getEnchantmentIndex(filterStack, slot);
        if (index <= 0) {
            return null;
        }
        index -= 2;
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.func_70301_a(slot);
        if (ghostStack.func_190926_b()) {
            return null;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)ghostStack);
        if (enchants.size() < index) {
            return null;
        }
        ArrayList enchantList = new ArrayList(enchants.entrySet());
        Map.Entry entry = enchantList.get(index);
        return Pair.of((Object)((Enchantment)entry.getKey()), (Object)((Integer)entry.getValue()));
    }

    public boolean getIsFuzzy(ItemStack filterStack, int slot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            filterStack.func_77982_d(tag);
        }
        return tag.func_74767_n("button:enchant_fuzzy" + slot);
    }

    public void setIsFuzzy(ItemStack filterStack, int slot, boolean value) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            filterStack.func_77982_d(tag);
        }
        tag.func_74757_a("button:enchant_fuzzy" + slot, value);
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            filterStack.func_77982_d(new CompoundNBT());
            tag = filterStack.func_77978_p();
        }
        if (buttonKey.equals("enchant")) {
            this.cycleToNextEnchant(filterStack, ghostItemSlot);
        } else if (buttonKey.equals("enchant_lvl")) {
            this.setIsFuzzy(filterStack, ghostItemSlot, currentButtonState == 0);
        }
        return super.receiveButtonPress(filterStack, buttonKey, ghostItemSlot, currentButtonState);
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag != null) {
            if (buttonKey.equals("enchant")) {
                int state = this.getEnchantmentIndex(filterStack, ghostItemSlot);
                return state;
            }
            if (buttonKey.equals("enchant_lvl")) {
                return this.getIsFuzzy(filterStack, ghostItemSlot) ? 1 : 0;
            }
        }
        return super.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<ITextComponent> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        List<ITextComponent> componentList = super.getTextForHoverItem(filterStack, buttonKey, ghostItemSlot);
        if (ghostItemSlot < 0) {
            return componentList;
        }
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("enchant")) {
            if (currentState != 0 && currentState != 1) {
                Pair<Enchantment, Integer> enchant = this.getEnchantment(filterStack, ghostItemSlot);
                if (enchant == null) return componentList;
                componentList.add(((Enchantment)enchant.getLeft()).func_200305_d(((Integer)enchant.getRight()).intValue()));
                return componentList;
            }
            InventoryFilter inv = new InventoryFilter(filterStack);
            ItemStack ghostStack = inv.func_70301_a(ghostItemSlot);
            if (ghostStack.func_190926_b()) {
                componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.noenchant"));
                return componentList;
            }
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)ghostStack);
            if (enchants.size() <= 0) {
                componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.noenchant"));
                return componentList;
            }
            if (currentState == 0) {
                componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.anyenchant"));
            } else {
                componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.allenchant"));
            }
            Iterator iterator = enchants.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                componentList.add(((Enchantment)entry.getKey()).func_200305_d(((Integer)entry.getValue()).intValue()));
            }
            return componentList;
        }
        if (!buttonKey.equals("enchant_lvl")) return componentList;
        boolean isFuzzy = this.getIsFuzzy(filterStack, ghostItemSlot);
        if (isFuzzy) {
            componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.enchantfuzzy"));
            return componentList;
        }
        componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.enchantnotfuzzy"));
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.IPressable>> getButtonAction(ContainerFilter container) {
        List<Pair<String, Button.IPressable>> buttonList = super.getButtonAction(container);
        buttonList.add((Pair<String, Button.IPressable>)Pair.of((Object)"enchant", (Object)new FilterButtonTogglePress("enchant", container)));
        buttonList.add((Pair<String, Button.IPressable>)Pair.of((Object)"enchant_lvl", (Object)new FilterButtonTogglePress("enchant_lvl", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("enchant")) {
            switch (currentButtonState) {
                case 0: {
                    return Pair.of((Object)216, (Object)0);
                }
                case 1: {
                    return Pair.of((Object)216, (Object)20);
                }
            }
            return Pair.of((Object)216, (Object)40);
        }
        if (buttonKey.equals("enchant_lvl")) {
            switch (currentButtonState) {
                case 0: {
                    return Pair.of((Object)236, (Object)0);
                }
            }
            return Pair.of((Object)236, (Object)20);
        }
        return super.getTexturePositionForState(filterStack, buttonKey, currentButtonState);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return super.isButtonGlobal(filterStack, buttonKey);
    }
}

